package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentOnCarAppVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 消防车信息
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_car")
@ApiModel(value = "Car对象", description = "消防车信息")
public class Car extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "名称")
	private String name;

	@ApiModelProperty(value = "车牌号")
	private String carNum;

	@ApiModelProperty(value = "车辆类型")
	private Long equipmentId;

	@ApiModelProperty(value = "车辆状态")
	private String carState;

	@ApiModelProperty(value = "品牌")
	private String brand;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "规格型号")
	private String standard;

	@ApiModelProperty(value = "底盘品牌")
	private String chassisBrand;

	@ApiModelProperty(value = "厂商id")
	private Long manufacturerId;

	@ApiModelProperty(value = "底盘国别")
	private String chassisCountry;

	@ApiModelProperty(value = "国别")
	private String country;

	@ApiModelProperty(value = "进口国产")
	private Boolean isImport;

	@ApiModelProperty(value = "二维码")
	private String qrCode;

	@ApiModelProperty(value = "全部二维码含类型标识03#qrCode")
	@TableField(exist = false)
	private String fullQrCode;

	@ApiModelProperty(value = "保养周期")
	private BigDecimal maintenanceCycle;

	@ApiModelProperty(value = "3c认证")
	private Boolean cccAuth;

	@ApiModelProperty(value = "负责人")
	private Long creatorId;

	@ApiModelProperty(value = "组织机构")
	private String orgCode;

	@ApiModelProperty(value = "公司名")
	private String companyName;

	@ApiModelProperty(value = "部门code")
	private String departmentOrgcode;

	@ApiModelProperty(value = "部门名")
	private String departmentName;

	@ApiModelProperty(value = "物联编码")
	private String iotCode;

	@ApiModelProperty(value = "所属单位id(来源于平台)")
	private String agencyId;

	@ApiModelProperty(value = "所属队伍id(来源于平台)")
	private String teamId;

	@ApiModelProperty(value = "队伍名称(冗余字段来源于平台)")
	private String teamName;



	//新加

	@ApiModelProperty(value = "机构/部门名称")
	@TableField("biz_org_name")
	private String bizOrgName;

	@ApiModelProperty(value = "机构编码")
	@TableField("biz_org_code")
	private String bizOrgCode;







	@ApiModelProperty(value = "图片")
	@TableField(exist = false)
	private List<UploadFile> img;

	@ApiModelProperty(value = "视频")
	@TableField(exist = false)
	private List<UploadFile> video;

	@ApiModelProperty(value = "证书")
	@TableField(exist = false)
	private List<UploadFile> certification;

	@ApiModelProperty(value = "说明")
	@TableField(exist = false)
	private List<UploadFile> instruction;

	@TableField(exist = false)
	private Equipment equipment;

	@TableField(exist = false)
	private String manufacturerName;

	@TableField(exist = false)
	private String countryName;
	
	@TableField(exist = false)
	private String chassisCountryName;
	
	@TableField(exist = false)
	private ManufacturerInfo manufacturerInfo;

	@TableField(exist = false)
	private List<CarProperty> carPropertyList;

	@TableField(exist = false)
	private List<Journal> journals;

	@TableField(exist = false)
	private List<EquipmentOnCarAppVO> EquipmentsOnCar;

	@TableField(exist = false)
	@ApiModelProperty(value = "扩展字段")
	private String ext;
	
	@TableField(exist = false)
	private String unitName;

	@TableField(exist = false)
	private Unit unit;
	
	@ApiModelProperty(value = "证书")
	@TableField(exist = false)
	private String iotStatus;

}
