package com.yeejoin.equipmanage.common.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_car_info")
@ApiModel(value="CarInfo对象", description="")
public class CarInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "车辆id")
    private Long carId;

    @ApiModelProperty(value = "长度")
    private Double length;

    @ApiModelProperty(value = "宽度")
    private Double width;

    @ApiModelProperty(value = "高度")
    private Double height;

    @ApiModelProperty(value = "总重量")
    private Double totalWeight;

    @ApiModelProperty(value = "装备重量")
    private Double equipWeight;

    @ApiModelProperty(value = "满载重量")
    private Double fullLoadWeight;

    @ApiModelProperty(value = "车辆接近角(度)'")
    private Double approachAngle;

    @ApiModelProperty(value = "车辆离去角(度)")
    private Double departureAngle;

    @ApiModelProperty(value = "油耗标准(升/百公里)")
    private Double fuelConsumption;

    @ApiModelProperty(value = "发动机功率(千瓦)")
    private Double enginePower;

    @ApiModelProperty(value = "吨位")
    private Double tonnage;

    @ApiModelProperty(value = "邮箱容量")
    private Double tankCapacity;

    private String chassisModel;

    private Integer fullLoadNumberOfPeople;

    private Integer seatNumber;

    private Integer engineNumber;

    private String engineModel;

    private String tcAuthentication;

    private String inspectionBatch;

    private String mainWork;

    private String wheeledCaterpillar;

    private String otherWork;

    private String specialFunction;

    private String maintenanceInstructions;

    private String profile;

    private String remark;

    private Integer isInfrared;

    private Integer isCamera;


    private String operationInstructions;

    private String tempId;

    private Long oilTypeId;

    private Long lubricantTypeId;

    private Long greaseTypeId;

    private Long outfireModeId;

    private Long drivingStyleId;

    private Long driveTypeId;

    private Long engineCoolingId;

    private Long engineTypeId;

    private Long gearboxTypeId;

    private Long hydraulicOilId;

    private Long wingTypeId;

    private Long ptoId;

    private Long motorcycleTypeId;
    @TableField(exist=false)
    private String driveType;
    @TableField(exist=false)
    private String motorcycleType;
    @TableField(exist=false)
    private String engineType;
    @TableField(exist=false)
    private String hydraulicOil; 
    @TableField(exist=false)
    private String gearboxType;
    @TableField(exist=false)
    private String wingType;
    @TableField(exist=false)
    private String outfireMode;
    @TableField(exist=false)
	private String lubricantType;
    @TableField(exist=false)
	private String engineCooling;
    @TableField(exist=false)
	private String pto;
    @TableField(exist=false)
	private String drivingStyle;
    @TableField(exist=false)
	private String greaseType;
    @TableField(exist=false)
	private String oilType;



}
