package com.yeejoin.equipmanage.common.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_car_property")
@ApiModel(value = "CarProperty对象", description = "")
public class CarProperty extends BaseEntity {

	private static final long serialVersionUID = 1L;

	private Long carId;

	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String value;

	private String remark;

	/**
     * 指标id
     */
    @TableField(value = "equipment_index_id")
	private Long equipmentIndexId;
	
    /**
     * 指标名称
     */
    @TableField(value = "equipment_index_name")
	private String equipmentIndexName;
	
    /**
     * 指标key
     */
    @TableField(value = "equipment_index_key")
	private String equipmentIndexKey;

	@TableField(exist = false)
	private String unitName;
	@TableField(exist = false)
	private String perfQuotaName;
	@TableField(exist = false)
	private String groupName;
	@TableField(exist = false)
	private String nameKey;

}
