package com.yeejoin.equipmanage.common.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FillCommonUserField;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author keyong
 * @title: EquipmentAlarmReportDay
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/5/18 13:52
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_alarm_report_day")
@FillCommonUserField(isAutoFill = false)
@ApiModel(value = "设备报警日报表对象", description = "设备报警日报表")
public class EquipmentAlarmReportDay extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "机构编号")
    private String orgCode;

    @ApiModelProperty(value = "上报日期")
    private Date reportDate;

    @ApiModelProperty(value = "设备id")
    private Long equipmentSpecificId;

    @ApiModelProperty(value = "设备名称")
    private String equipmentSpecificName;

    @ApiModelProperty(value = "装备实例明细id(冗余字段)")
    private Long equipmentDetailId;

    @ApiModelProperty(value = "装备定义id(冗余字段)")
    private Long equipmentId;

    @ApiModelProperty(value = "遥信指标true类型指标数量(统计使用)")
    private Long indexTrueNum;

    @ApiModelProperty(value = "装备定义code(冗余字段)")
    private String equipmentCode;

    @ApiModelProperty(value = "所属系统名称")
    private String systemIds;

    @ApiModelProperty(value = "原始报警类型")
    private String alarmType;

    @ApiModelProperty(value = "冗余字段（分析报告统计使用）")
    private String alarmTypeName;

    @ApiModelProperty(value = "最后一次上报日期")
    private Date lastReportDate;

    @ApiModelProperty(value = "发生频次")
    private int frequency;

    @ApiModelProperty(value = "更新时间")
    private Date updateDate;

    @ApiModelProperty(value = "告警指标Id")
    private Long indexId;

    @ApiModelProperty(value = "告警指标名称")
    private String indexName;

    @ApiModelProperty(value = "告警指标key值")
    private String indexType;

    @ApiModelProperty(value = "指标最新值")
    private String value;
}
