package com.yeejoin.equipmanage.common.entity.dto;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonInclude;

import lombok.Data;
/**
 * <p>
 * 
 * </p>
 *
 * @author 子杨
 * @since 2021-10-14
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TopographyLineDTO implements Serializable {

        /**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = 3067750215106584790L;
	
		/**
         * 起点
         */
    private String lineFrom;
    private String from;
        /**
         * 终点
         */
    private String lineTo;
    private String to;
        /**
         * 树id
         */
    private String treeid;
    private String id;
    private Date createDate;
    private String createUser;
    private Boolean isDelete;
    private Date updateDate;
    private String updateUser;
        /**
         * 可点击
         */
    private Boolean clickable;
        /**
         * 树节点id
         */
    private String treeNodeId;
        /**
         * 异常数量
         */
    private Integer number;
        /**
         * 异常状态
         */
    private Integer state;
        /**
         * 类型：1-网络拓扑图，2-PAMS
         */
    private Integer type;
        /**
         * 有箭头
         */
    private Boolean hasArrow;
        /**
         * 起点位置
         */
    private String fromPort;
        /**
         * 终点位置
         */
    private String toPort;
        /**
         * 是虚线
         */
    private Boolean isDash;
        /**
         * 颜色
         */
    private Integer lineColor;
        /**
         * 部门单位
         */
    private String orgCode;
	    /**
	     * 告警消息
	     */
	private String warnMessage;
	    /**
	     * 状态码
	     */
	private int warnState = 0;

}
