package com.yeejoin.equipmanage.common.enums;

import com.yeejoin.equipmanage.common.vo.Result;

/**
 * <pre>
 * 
 * </pre>
 *
 */
public class EquipStatusChecker {

	/**
	 * 判断装备是否能够维修
	 * 
	 * @param status
	 * @return
	 */
	public static Result isRepairable(EquipStatusEnum status) {
		switch (status) {
		case REPAIR:
			return createResult(false, "该装备正在维修中，不能重复维修！");
		// case LOAN:
		// return createResult(false, "该装备已借出，不能维修！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能维修！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能维修！");
		//
		case SCRAP:
			return createResult(false, "该装备已报废，不能维修！");
		case LOSS:
			return createResult(false, "该装备已损耗，不能维修！");
		case LOAD:
			return createResult(false, "该装备已配装，不能维修！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够保养
	 * 
	 * @param status
	 * @return
	 */
	public static Result isMaintenanceable(EquipStatusEnum status) {
		switch (status) {
		case REPAIR:
			return createResult(false, "该装备正在维修中，不能保养！");
		// case LOAN:
		// return createResult(false, "该装备已借出，不能保养！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能保养！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能保养！");
		case SCRAP:
			return createResult(false, "该装备已报废，不能保养！");
		case LOSS:
			return createResult(false, "该装备已损耗，不能保养！");
		case LOAD:
			return createResult(false, "该装备已配装，不能保养！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够保养
	 * 
	 * @param status
	 * @return
	 */
	public static Result isAllocationable(EquipStatusEnum status) {
		switch (status) {
		case REPAIR:
			return createResult(false, "该装备正在维修中，不能调拨！");
		// case LOAN:
		// return createResult(false, "该装备已借出，不能调拨！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能调拨！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能调拨！");
		case SCRAP:
			return createResult(false, "该装备已报废，不能调拨！");
		case LOSS:
			return createResult(false, "该装备已损耗，不能调拨！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够出库
	 * 
	 * @param status
	 * @return
	 */
	public static Result isOutStockable(EquipStatusEnum status) {
		switch (status) {
		case REPAIR:
			return createResult(false, "该装备正在维修中，不能出库！");
		// case LOAN:
		// return createResult(false, "该装备已借出，不能执行出库操作！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能执行出库操作！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能执行出库操作！");
		case SCRAP:
				return createResult(false, "该装备已报废，不能执行出库操作！");
		case LOAD:
			return createResult(false, "该装备已配装，不能执行出库操作！");


		// case ONDUTY:
		// return createResult(false, "该装备正在执勤中，不能执行出库操作！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够借用
	 * 
	 * @param status
	 * @return
	 */
	public static Result isBorrowable(EquipStatusEnum status) {
		switch (status) {
		case REPAIR:
			return createResult(false, "该装备正在维修中，不能借出！");
		// case LOAN:
		// return createResult(false, "该装备已借出，不能再次借出！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能借出！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能借用！");
		case SCRAP:
			return createResult(false, "该装备已报废，不能借出！");
		// case ONDUTY:
		// return createResult(false, "该装备正在执勤中，不能借出！");
		case LOSS:
			return createResult(false, "该装备已损耗，不能借出！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断是否可被转移
	 * 
	 * @param status
	 * @return
	 */
	public static Result isTransfer(EquipStatusEnum status) {
		switch (status) {
		case REPAIR:
			return createResult(false, "该装备正在维修中，不能转移货位！");
		// case LOAN:
		// return createResult(false, "该装备已借出，不能转移货位！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能转移货位！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能转移货位！");
		case SCRAP:
			return createResult(false, "该装备已报废，不能转移货位！");
		// case ONDUTY:
		// return createResult(false, "该装备正在执勤中，不能转移货位！");
		case LOSS:
			return createResult(false, "该装备已损耗，不能转移货位！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够执勤
	 * 
	 * @param status
	 * @return
	 */
	public static Result onDutyable(EquipStatusEnum status) {
		switch (status) {
		case REPAIR:
			return createResult(false, "该装备正在维修中，不能执勤！");
		// case LOAN:
		// return createResult(false, "该装备已借出，不能执勤！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能执勤！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能执勤！");
		case SCRAP:
			return createResult(false, "该装备已报废，不能执勤！");
		// case ONDUTY:
		// return createResult(false, "该装备正在执勤中，不能重复执勤！");
		case LOSS:
			return createResult(false, "该装备已损耗，不能执勤！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够变成库存
	 * 
	 * @param status
	 * @return
	 */
	public static Result isStockable(EquipStatusEnum status) {
		switch (status) {
		// case LOAN:
		// return createResult(false, "该装备已借出，不能变为在位状态！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能变为在位状态！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能变为在位状态！");
		case SCRAP:
			return createResult(false, "该装备已报废，不能变为在位状态！");
		case LOSS:
			return createResult(false, "该装备已损耗，不能变为在位状态！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够退役
	 * 
	 * @param status
	 * @return
	 */
	public static Result isRetirementable(EquipStatusEnum status) {
		switch (status) {
		// case LOAN:
		// return createResult(false, "该装备已借出，不能退役！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能退役！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能退役！");
		case SCRAP:
			return createResult(false, "该装备已报废，不能退役！");
		case LOSS:
			return createResult(false, "该装备已损耗，不能退役！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够报废
	 * 
	 * @param status
	 * @return
	 */
	public static Result isScrapable(EquipStatusEnum status) {
		switch (status) {
		// case LOAN:
		// return createResult(false, "该装备已借出，不能报废！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能报废！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能报废！");
		case SCRAP:
			return createResult(false, "该装备已报废，不能再次报废！");
		// case ONDUTY:
		// return createResult(false, "该装备正在执勤中，请先退役后再进行报废操作！");
//		case REPERTORY:
//			return createResult(false, "该装备目前是库存状态，请先退役后再进行报废操作！");
		case LOSS:
			return createResult(false, "该装备目前是损耗状态，不能进行报废操作！");
		case LOAD:
			return createResult(false, "该装备已配装，不能报废！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够装载装备
	 * 
	 * @param status
	 * @return
	 */
	public static Result isLoadable(EquipStatusEnum status) {
		switch (status) {
		// case LOAN:
		// return createResult(false, "该装备已借出，不能被装载！");
		// case BORROW:
		// return createResult(false, "该装备是借用装备，不能被装载！");
		// case RETURN:
		// return createResult(false, "该借用装备已归还借用方，不能被装载！");
		case SCRAP:
			return createResult(false, "该装备已报废，不能被装载！");
		case REPAIR:
			return createResult(false, "该装备正在维修中，不能被装载！");
		case LOSS:
			return createResult(false, "该装备目前是损耗状态，不能进行装载操作！");
		case LOAD:
			return createResult(false, "该装备已配装，不能被装载！");
		default:
			return createResult(true, "");
		}
	}

	/**
	 * 判断装备是否能够装载装备
	 * 
	 * @param status
	 * @return
	 */
	public static Result isReturnable(EquipStatusEnum status) {
		switch (status) {
		// case BORROW:
		// return createResult(false, "该装备是借用装备，请让借出方执行归还操作！");
		// case LOAN:
		// return createResult(true, "");
		default:
			return createResult(false, "该装备未被借出，不能进行归还操作！");
		}
	}

	public static Result createResult(boolean bool, String msg) {
		Result result = new Result();
		if (!bool) {
			result.setOk(bool);
			result.setMsg(msg);
		}
		return result;
	}

}
