package com.yeejoin.equipmanage.common.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.response
 * @ClassName: Common3dResponse
 * @Author: Jianqiang Gao
 * @Description: Common3dResponse
 * @Date: 2021/6/3 11:03
 * @Version: 1.0
 */
@ApiModel(description = "数字化三维统一规范")
public class Common3dResponse {

    /**
     * id
     */
    private Integer id;
    /**
     * 操作状态
     */
    @ApiModelProperty(required = true, value = "操作状态")
    private String code;

    /**
     * 操作详细信息
     */
    @ApiModelProperty(required = false, value = "操作详细信息")
    private String message;

    /**
     * 数据
     */
    @ApiModelProperty(required = false, value = "数据")
    private Object body;

    public Common3dResponse() {

    }

    public Common3dResponse(String code) {
        this.code = code;
    }

    public Common3dResponse(Object body) {
        this.body = body;
        this.code = "";
    }

    public Common3dResponse(String code, Object body) {
        this.body = body;
        this.code = code;
    }

    public Common3dResponse(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public Common3dResponse(String code, Object body, String message) {
        this.body = body;
        this.code = code;
        this.message = message;
    }

//    public Boolean isSuccess() {
//        return "SUCCESS".equals(getCode());
//    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getBody() {
        return body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public String toJsonStr() throws Exception {
        return JSON.toJSONString(this, SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.SkipTransientField);
    }
}