package com.yeejoin.equipmanage.common.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.BaseRowModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 消防设施资源数据对象 mt_maintenance_resource_data
 *
 * @author gaojianqiang
 * @date 2021-07-16
 */
@Data
@ApiModel(value = "MaintenanceResourceDataVo", description = "维保设施资源数据Vo")
public class MaintenanceResourceDataVo  extends BaseRowModel {

    /**
     * 维保单位ID
     */
    @ExcelIgnore
    private Long maintenanceCompanyId;

    /**
     * 维保单位编码
     */
    @ExcelIgnore
    private String maintenanceCompanyCode;

    /**
     * 维保单位名称
     */
    @ExcelProperty(value = "维保单位", index = 9)
    private String maintenanceCompanyName;

    /**
     * 业主单位ID
     */
    @ExcelIgnore
    private Long ownerUnitId;

    /**
     * 业主单位编码
     */
    @ExcelIgnore
    private String ownerUnitCode;

    /**
     * 业主单位名称
     */
    @ExcelProperty(value = "所属单位", index = 0)
    @Excel(name = "所属单位", width = 30, orderNum = "7")
    private String ownerUnitName;

    /**
     * 消防系统ID
     */
    @ExcelIgnore
    private Long fireFightSysId;

    /**
     * 消防系统编码
     */
    @ExcelIgnore
    private String fireFightSysCode;

    /**
     * 消防系统名称
     */
    @ExcelProperty(value = "所属消防系统", index = 1)
    @Excel(name = "所属消防系统", width = 30, orderNum = "4")
    private String fireFightSysName;

    /**
     * 分类ID
     */
    @ExcelIgnore

    private Long classifyId;

    /**
     * 分类编码
     */
    @ExcelIgnore
    private String classifyCode;

    /**
     * 分类名称
     */
    @ExcelProperty(value = "设施类型", index = 3)
    @Excel(name = "设施类型", width = 30, orderNum = "3")
    private String classifyName;

    /**
     * 分类类型
     */
    @ExcelIgnore
    private String classifyType;

    /**
     * 消防设施ID
     */
    @ExcelIgnore
    private Long fireFacilityId;

    /**
     * 消防设施编码
     */
    @ExcelProperty(value = "设施编码", index = 2)
    @Excel(name = "设施编码", width = 30, orderNum = "6")
    private String fireFacilityCode;

    /**
     * 消防设施名称
     */
    @ExcelProperty(value = "设施名称", index = 4)
    @Excel(name = "设施名称", width = 30, orderNum = "1")
    private String fireFacilityName;

    /**
     * 消防设施类型
     */
    @ExcelIgnore
    private String fireFacilityType;

    /**
     * 维保周期
     */
    @ExcelProperty(value = "维保周期", index = 8)
    private Integer maintenanceCycle;

    /**
     * 维保到期时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty(value = "到期维保时间", index = 5)
    @Excel(name = "到期维保时间", exportFormat = "yyyy-MM-dd HH:mm:ss", importFormat = "yyyy-MM-dd HH:mm:ss", width = 30, orderNum = "5")
    private Date maintenanceExpirationTime;

    /**
     * 位置
     */
    @ExcelProperty(value = "安装或设置位置", index = 6)
    @Excel(name = "安装或设置位置", width = 50, orderNum = "2")
    private String location;

    /**
     * 新增和更新执行
     */
    @ExcelProperty(value = "添加时间", index = 7)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "添加时间", exportFormat = "yyyy-MM-dd HH:mm:ss", importFormat = "yyyy-MM-dd HH:mm:ss", width = 30, orderNum = "8")
    private Date createDate;

    /**
     * 建筑ID
     */
    @ExcelIgnore
    private Long buildingId;

    /**
     * 建筑名称
     */
    @ExcelIgnore
    private String buildingName;

    /**
     * 是否已关联
     */
    @ExcelIgnore
    private List<Long> buildingIds;

    /**
     * 是否已关联
     */
    @ExcelIgnore
    private Boolean isRelation;

}
