package com.yeejoin.amos.fas.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;



/**
 * 
 * <pre>
 * 消息实体
 * </pre>
 *
 * @author HK
 * @version $Id: Message.java, v 0.1 2018年1月18日 下午7:48:58 HK Exp $
 */
@Entity
@Table(name = "toip_sys_message") 
public class Message extends BusinessEntity
{

	/**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = 292329658525267887L;
	
	/**
	 * id
	 */
	@Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid2")
	@Column(name = "id", nullable = false, length = 36)
	protected String id;

	/**
	 * 时间
	 */
	private Date time;
	/**
	 * 标题
	 */
	private String title;
	/**
	 * 内容
	 */
	private String content;
	/**
	 * 类型
	 */
	private String type;
	/**
	 * 发送者
	 */
	private String sender;
	/**
	 * 接收者
	 */
	private String receiver;
	/**
	 * 已读者
	 */
	private String reader;
	/**
	 * 业务id
	 */
	private String bizId;
	/**
	 * 业务员实体名，例如com.yeejoin.amos.toip.bizrulebridge.entity.Fire
	 */
	private String bizclassName;

	
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public Date getTime()
	{
		return time;
	}

	public void setTime(Date time)
	{
		this.time = time;
	}

	public String getTitle()
	{
		return title;
	}

	public void setTitle(String title)
	{
		this.title = title;
	}

	public String getContent()
	{
		return content;
	}

	public void setContent(String content)
	{
		this.content = content;
	}

	public String getType()
	{
		return type;
	}

	public void setType(String type)
	{
		this.type = type;
	}

	public String getSender()
	{
		return sender;
	}

	public void setSender(String sender)
	{
		this.sender = sender;
	}

	public String getReceiver()
	{
		return receiver;
	}

	public void setReceiver(String receiver)
	{
		this.receiver = receiver;
	}

	public String getReader()
	{
		return reader;
	}

	public void setReader(String reader)
	{
		this.reader = reader;
	}

	public String getBizId()
	{
		return bizId;
	}

	public void setBizId(String bizId)
	{
		this.bizId = bizId;
	}

	public String getBizclassName()
	{
		return bizclassName;
	}

	public void setBizclassName(String bizclassName)
	{
		this.bizclassName = bizclassName;
	}

}
