package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;
import lombok.Data;

import java.io.Serializable;
/**
 * 
 * <pre>
 * 警情报送规则触发对象
 * </pre>
 *
 * @author gwb
 * @version $Id: AlertCalledRo.java, v 0.1 2021年6月24日 下午3:31:14 gwb Exp $
 */
@Data
@RuleFact(value = "警情信息",project = "西咸机场119接处警规则")
public class AlertCalledRo implements Serializable{




	/**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = -8755622977733065123L;

	/**
	 * 通用属性
	 */
	@Label("警情id")
    private String sequenceNbr;
	
	@Label(value = "警情时间")
    private String callTimeStr;
   
    @Label(value = "警情类型")
    private String alertType;

    @Label(value = "警情类型code")
    private String alertTypeCode;
    
    @Label(value = "发送单位")
    private String companyName;

    @Label(value = "联系人")
    private String contactUser;

    @Label(value = "联系电话")
    private String contactPhone;

    @Label(value = "被困人数")
    private String trappedNum;

    @Label(value = "伤亡人数")
    private String casualtiesNum;
    
    @Label(value = "地址")
    private String address;

    @Label(value = "警情报送id")
    private String alertSubmittedId;

    @Label(value = "事发单位")
    private String unitInvolved;

    @Label(value = "模板替换内容")
    private String replaceContent;

    @Label(value = "警情报送类型(0，警情报送，1，警情续报，2，非警情确认，3，警情结案)")
    private String alertWay;

    @Label(value = "警情续报，非警情确认，警情结案，选择人员电话号码")
    private String ids;

    @Label(value = "警情续报，非警情确认，警情结案，选择人员AmousIds")
    private String usIds;

    @Label(value = "警情续报自定义内容")
    private String feedback;



    /**
     * 一般火灾
     */
    @Label(value = "失火位置")
    private String fireLocation;
    
    @Label(value = "燃烧物质")
    private String burningMaterial;
    
    @Label(value = "火势情况")
    private String fireSituation;
    
    @Label(value = "危险爆炸品")
    private String dangerousExplosives;
    /**
     * 航空器救援
     */
    @Label(value = "航班号")
    private String flightNumber;

    @Label(value = "飞机型号")
    private String aircraftModel;

    @Label(value = "落地时间")
    private String landingTime;

    @Label(value = "灾害事故情况")
    private String accidentSituationHkq;

    @Label(value = "燃油量")
    private String fuelQuantity;

    @Label(value = "发展态势")
    private String developmentTrend;


    @Label(value = "载客量")
    private String passengerCapacity;

    @Label(value = "航空器故障部位")
    private String damageLocation;

    @Label(value = "迫降跑道")
    private String forcedLandingTrack;

    /**
     * 突发事件救援
     */
    @Label(value = "灾害事故情况")
    private String accidentSituation;

    /**
     * 漏油现场安全保障
     */
    @Label(value = "航班号")
    private String flightNumberLy;
    @Label(value = "机位")
    private String seat;
    @Label(value = "漏油面积")
    private String oilLeakageArea;

    /**
     * 专机保障
     */
    @Label(value = "保障等级")
    private String securityLevel;
    @Label(value = "机位")
    private String seatBz;

    /**
     * 120急救
     */
    @Label(value = "患者现状")
    private String patientStatus;
    @Label(value = "性别")
    private String gender;
    @Label(value = "年龄段")
    private String ageGroup;



//
//    /**
//     * 其他
//     */
//    @Label(value = "灾害事故情况")
//    private String accidentSituation;



}
