package com.yeejoin.amos.boot.module.jcs.api.service;

import com.yeejoin.amos.boot.module.jcs.api.dto.TemplateExtendDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Template;

/**
* 模板表 服务类
*
* @author tb
* @date 2021-06-17
*/
public interface ITemplateService {

    /**
     * 根据模板类型及模板格式类型获取模板信息
     *
     * @param type 模板类型
     * @param format 模板格式类型（1：富文本，0：其他）
     * @return
     */
    Template getByTypeAndFormat(String type, String format);

    /**
     * 根据模板类型获取模板信息
     *
     * @param type 模板类型
     * @return
     */
    TemplateExtendDto getByType(String type);
}
