package com.yeejoin.amos.latentdanger.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AuditEnum {
	AUDIT("待审核","audit"),
	REVIEW("待复核","review");

	/**
	 * 名称，描述
	 */
	private String name;

	/**
	 * 编码
	 */
	private String code;

	AuditEnum(String name, String code){
		this.name = name;
		this.code = code;
	}
	
	public static AuditEnum getEnum(String code) {
		AuditEnum auditEnum = null;
		for(AuditEnum type: AuditEnum.values()) {
			if (type.getCode().equals(code)) {
				auditEnum = type;
				break;
			}
		}
		
		return auditEnum;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (AuditEnum c: AuditEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("code", c.getCode());
			nameList.add(map);
		}
		return nameList;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
