package com.yeejoin.amos.maintenance.common.enums;

import lombok.Data;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author DELL
 */
public enum  PlanTypeEnum {
    /**
     * 计划类型枚举
     */
    PLAN_TYPE_DAY("1","日计划"),
    PLAN_TYPE_WEEK("2","周计划"),
    PLAN_TYPE_MONTH("3","月计划"),
    PLAN_TYPE_YEAR("4","年计划");

    /**
     * 名称
     */
    private String name;
    /**
     * code
     */
    private String code;

    PlanTypeEnum(String code, String name){
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static PlanTypeEnum getEnumByCode(String code) {
        Optional<PlanTypeEnum> op = Arrays.stream(PlanTypeEnum.values()).filter(e->e.code.equals(code)).findFirst();
        return op.orElse(null);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
