package com.yeejoin.amos.patrol.common.enums;

import io.swagger.models.auth.In;

public enum LatentDangerLevelEnum {

    安全问题("安全问题", 0, "0"),
    一般隐患("一般隐患", 1, "1"),
    重大隐患("重大隐患", 2, "2");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    private String riskSourceDangerLevelCode;

    LatentDangerLevelEnum(String name, Integer code, String riskSourceDangerLevelCode) {
        this.name = name;
        this.code = code;
        this.riskSourceDangerLevelCode = riskSourceDangerLevelCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getRiskSourceDangerLevelCode() {
        return riskSourceDangerLevelCode;
    }

    public void setRiskSourceDangerLevelCode(String riskSourceDangerLevelCode) {
        this.riskSourceDangerLevelCode = riskSourceDangerLevelCode;
    }

    public static LatentDangerLevelEnum getByRiskSourceDangerLevelCode(String riskSourceDangerLevelCode) {
        for (LatentDangerLevelEnum l : LatentDangerLevelEnum.values()) {
            if (riskSourceDangerLevelCode.equals(l.getRiskSourceDangerLevelCode())) {
                return l;
            }
        }
        return null;
    }

    public static LatentDangerLevelEnum getByCode(Integer code) {
        for (LatentDangerLevelEnum l : LatentDangerLevelEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }

    public static LatentDangerLevelEnum getByCode(String code) {
        for (LatentDangerLevelEnum l : LatentDangerLevelEnum.values()) {
            if (l.getCode().equals(Integer.parseInt(code))) {
                return l;
            }
        }
        return null;
    }
}
