package com.yeejoin.amos.supervision.dao.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.util.Date;

/**
 * @ProjectName: amos-biz-boot
 * @Package: com.yeejoin.amos.supervision.dao.entity
 * @ClassName: PlanAudit
 * @Author: Jianqiang Gao
 * @Description: 计划审核申请表
 * @Date: 2021/9/23 9:52
 * @Version: 1.0
 */
@Entity
@Table(name = "p_plan_audit")
@NamedQuery(name = "PlanAudit.findAll", query = "SELECT p FROM PlanAudit p")
@Data
public class PlanAudit extends BasicEntity {

    private static final long serialVersionUID = 1L;
    /**
     * 计划id
     */
    @Column(name = "plan_id")
    private Long planId;
    /**
     * 业务唯一标识
     */
    @Column(name = "business_key")
    private String businessKey;

    /**
     * 工作流实例编号
     */
    @Column(name = "process_instance_id")
    private String processInstanceId;
    /**
     * 流程定义key
     */
    @Column(name = "process_definition_key")
    private String processDefinitionKey;
    /**
     * 启动者id
     */
    @Column(name = "start_user_id")
    private String startUserId;
    /**
     * 更新时间
     */
    @Column(name = "update_date")
    private Date updateDate;

}