package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 设备告知单
 *
 * @author system_generator
 * @date 2021-12-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="EquipmentInformDto", description="设备告知单")
public class EquipmentInformDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "施工告知编号")
    private String productCode;

    @ApiModelProperty(value = "施工告知日期")
    private Date productInformDate;

    @ApiModelProperty(value = "施工单位")
    private String productUnit;

    @ApiModelProperty(value = "施工单位id")
    private Long productUnitId;

    @ApiModelProperty(value = "施工类型")
    private String productType;

    @ApiModelProperty(value = "施工类型code")
    private String productTypeCode;

    @ApiModelProperty(value = "生产许可证编号")
    private String licenceCode;

    @ApiModelProperty(value = "生产许可证有效期")
    private Date licenceDate;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "县区")
    private String district;

    @ApiModelProperty(value = "街道")
    private String stree;

    @ApiModelProperty(value = "小区")
    private String community;

    @ApiModelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "施工负责人")
    private String principal;

    @ApiModelProperty(value = "施工负责人id")
    private Long principalId;

    @ApiModelProperty(value = "施工负责人电话")
    private String principalPhone;

    @ApiModelProperty(value = "计划施工日期")
    private Date planProductDate;

    @ApiModelProperty(value = "接收机构")
    private String acceptUnit;

    @ApiModelProperty(value = "接收机构id")
    private Long acceptUnitId;

    @ApiModelProperty(value = "检验机构")
    private String inspectonUnit;

    @ApiModelProperty(value = "检验机构id")
    private Long inspectonUnitId;

    @ApiModelProperty(value = "使用单位")
    private String useUnit;

    @ApiModelProperty(value = "使用单位id")
    private Long useUnitId;

    @ApiModelProperty(value = "产权单位")
    private String propertyUnit;

    @ApiModelProperty(value = "产权单位id")
    private Long propertyUnitId;

    @ApiModelProperty(value = "使用场所")
    private String useSite;

    @ApiModelProperty(value = "使用场所code")
    private String useSiteCode;

    @ApiModelProperty(value = "告知书编号")
    private String informCode;

    @ApiModelProperty(value = "告知单状态 0 暂存 1未接收 9已接收")
    private String informStatus;

   @ExcelIgnore
   @ApiModelProperty(value = "附件")
   @TableField(exist = false)
   private Map<String, List<AttachmentDto>> attachments;

   @ApiModelProperty(value = "设备数量")
   private Integer equipmentNum;

  @ApiModelProperty(value = "开始-施工告知日期")
  private String productInformDateStart;

  @ApiModelProperty(value = "结束-施工告知日期")
  private String productInformDateEnd;

  @ApiModelProperty(value = "开始-计划施工日期")
  private String planProductDateStart;

  @ApiModelProperty(value = "结束-计划施工日期")
  private String planProductDateEnd;

 @ApiModelProperty(value = "施工区域")
  private String productArea;

 @ApiModelProperty(value = "流程ID")
 private String processId;

 @ApiModelProperty(value = "流程状态")
 private String processStatus;


}
