package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FireExpertsDto;
import com.yeejoin.amos.boot.module.common.api.entity.FireExperts;
import com.yeejoin.amos.boot.module.common.api.mapper.FireExpertsMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFireExpertsService;

import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 服务实现类
 * 消防专家
 *
 * @author system_generator
 * @date 2021-06-25
 */
@Service
public class FireExpertsServiceImpl extends BaseService<FireExpertsDto, FireExperts, FireExpertsMapper> implements IFireExpertsService {
    /**
     * 分页查询
     */
    @Override
    public Page<FireExpertsDto> queryForFireExpertsPage(Page<FireExpertsDto> page,
                                                        @Condition(Operator.eq) Boolean isDelete,
                                                        @Condition(Operator.like) String name,
                                                        @Condition(Operator.eq) String expertCode) {
        // 消防专家按时间倒叙排列add rec_date 2021-09-08 by kongfm
        return this.queryForPage(page, "rec_date", false, isDelete, name, expertCode);
    }

    /**
     * 列表查询 示例
     */
    public List<FireExpertsDto> queryForFireExpertsList(@Condition(Operator.eq) Boolean isDelete,
    		 @Condition(Operator.like) String name,
             @Condition(Operator.eq) String expertCode) {
        return this.queryForList("", false, isDelete, name, expertCode);
    }
}
