//package com.yeejoin.equipmanage.config;
//
//import java.util.Arrays;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
//import javax.servlet.http.HttpServletRequest;
//
//import org.aspectj.lang.JoinPoint;
//import org.aspectj.lang.annotation.AfterReturning;
//import org.aspectj.lang.annotation.Aspect;
//import org.aspectj.lang.annotation.Before;
//import org.aspectj.lang.annotation.Pointcut;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.stereotype.Component;
//import org.springframework.web.context.request.RequestContextHolder;
//import org.springframework.web.context.request.ServletRequestAttributes;
//import org.typroject.tyboot.core.foundation.context.RequestContext;
//import org.typroject.tyboot.core.foundation.utils.Bean;
//
//import com.alibaba.fastjson.JSON;
//import com.alibaba.fastjson.JSONObject;
//import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
//import com.yeejoin.amos.boot.biz.common.bo.DepartmentBo;
//import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
//import com.yeejoin.amos.boot.biz.common.bo.RoleBo;
//import com.yeejoin.amos.component.feign.model.FeignClientResult;
//import com.yeejoin.amos.feign.privilege.Privilege;
//import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
//import com.yeejoin.amos.feign.privilege.model.CompanyModel;
//import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
//import com.yeejoin.amos.feign.privilege.model.RoleModel;
//import com.yeejoin.equipmanage.common.config.GlobalCache;
//import com.yeejoin.equipmanage.common.utils.RedisUtils;
//
//
///**
// * controller层切面 用于用户数据缓存 供 sql自动填充使用
// *
// * @author Admin
// */
//@Aspect
//@Component
//public class ControllerAop {
//    /**
//     * saveUserRedis设置过期时间
//     */
//    @Value("${redis_region_time_second}")
//    private Long redisRegionTimeSecond;
//
//    @Autowired
//    private RedisUtils redisUtils;
//
//    @Pointcut("execution(public * com.yeejoin.equipmanage.controller..*(..))")
//    public void userCache() {
//    }
//
//    @Before("userCache()")
//    public void doBefore(JoinPoint joinPoint) throws Throwable {
//        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
//        HttpServletRequest request = attributes.getRequest();
//        String token = getToken(request);
//        if (token != null) {
//            String product = request.getHeader("product");
//            String appKey = request.getHeader("appKey");
//            RequestContext.setToken(token);
//            RequestContext.setProduct(product);
//            RequestContext.setAppKey(appKey);
//            FeignClientResult<AgencyUserModel> feignClientResult = Privilege.agencyUserClient.getme();
//            AgencyUserModel userModel = feignClientResult.getResult();
//            if (userModel == null) {
//                throw new Exception("无法获取用户信息");
//            }
//            RequestContext.setExeUserId(userModel.getUserId());
//            String key = "region_" + userModel.getUserId() + "_" + token;
//            Map<String, Object> map = new HashMap<>();
//            map.put("user", JSON.toJSONString(userModel));
//
//            // 不需要添加请求头的接口
//            String[] url = new String[]{"/equip/api/user/selectInfo", "/equip/api/user/save/curCompany"};
//            System.out.println((Arrays.asList(url).toString()));
//            System.out.println(request.getRequestURI());
//            // 获取请求路径
//            if (Arrays.asList(url).contains(request.getRequestURI())) {
//                // 暂无需要
//            } else {
//                if (redisUtils.hasKey(key)) {
//                    map.put("org", redisUtils.get(key).toString());
//                    GlobalCache.paramMap.put(token, JSON.toJSONString(map));
//                } else {
//                    saveUserRedis(userModel, token);
//                }
//            }
//
//        }
//
//    }
//
//    public void saveUserRedis(AgencyUserModel user, String token) {
//        CompanyBo company = new CompanyBo();
//        DepartmentBo department = new DepartmentBo();
//        RoleBo role = new RoleBo();
//        CompanyModel companyM = user.getCompanys().get(0);
//        Bean.copyExistPropertis(companyM, company);
//        Map<Long, List<DepartmentModel>> mapDepartments = user.getCompanyDepartments();
//        DepartmentModel departmentM = mapDepartments.get(companyM.getSequenceNbr()).get(0);
//        Bean.copyExistPropertis(departmentM, department);
//        Map<Long, List<RoleModel>> roles = user.getOrgRoles();
//        Long sequenceNbr;
//        if (departmentM == null) {
//            sequenceNbr = null;
//        } else {
//            sequenceNbr = departmentM.getSequenceNbr();
//        }
//        RoleModel roleM = null;
//        if (sequenceNbr == null) {
//            roleM = roles.get(companyM.getSequenceNbr()).get(0);
//        } else {
//            roleM = roles.get(sequenceNbr).get(0);
//        }
//
//        Bean.copyExistPropertis(roleM, role);
//        ReginParams reginParams = new ReginParams();
//        reginParams.setCompany(company);
//        reginParams.setRole(role);
//        reginParams.setDepartment(department);
//        redisUtils.set(buildKey(user.getUserId(), token), JSONObject.toJSONString(reginParams), redisRegionTimeSecond);
//        Map<String, Object> map = new HashMap<>();
//        map.put("user", JSON.toJSONString(user));
//        map.put("org", JSONObject.toJSONString(reginParams));
//        GlobalCache.paramMap.put(token, JSON.toJSONString(map));
//    }
//
//
//    public String buildKey(String userId, String token) {
//        return "region_" + userId + "_" + token;
//    }
//
//    @AfterReturning(returning = "ret", pointcut = "userCache()")
//    public void doAfterReturning(Object ret) throws Throwable {
//        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
//        HttpServletRequest request = attributes.getRequest();
//        String token = getToken(request);
//        if (token != null) {
//            GlobalCache.paramMap.remove(token);
//        }
//    }
//
//    protected String getToken(HttpServletRequest request) {
//        String authToken = request.getHeader("token");
//        if (authToken == null) {
//            authToken = request.getHeader("X-Access-Token");
//        }
//        return authToken;
//    }
//}
