package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.dto.EquipmentOnCarDto;
import com.yeejoin.equipmanage.common.entity.EquipmentOnCar;
import com.yeejoin.equipmanage.common.enums.EquipStatusEnum;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.common.vo.EquipmentOnCarVo;
import com.yeejoin.equipmanage.service.IEquipmentOnCarService;
import com.yeejoin.equipmanage.service.IStockDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;


/**
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "车载装备Api")
@RequestMapping(value = "/equipment-on-car", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipmentOnCarController {

    @Autowired
    IEquipmentOnCarService iEquipmentOnCarService;

    @Autowired
    private IStockDetailService stockDetailService;


    /**
     * 新增
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveEquipmentOnCar(HttpServletRequest request, @RequestBody EquipmentOnCar equipmentOnCar) {
        return iEquipmentOnCarService.save(equipmentOnCar);
    }

    /**
     * 批量新增
     *
     * @return
     */
    @RequestMapping(value = "/saveBatch", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveBatch(HttpServletRequest request, @RequestBody List<EquipmentOnCar> list) {
        boolean saveBatch = iEquipmentOnCarService.saveBatch(list);
        if (saveBatch) {
            boolean updateBatch = stockDetailService.updateBatch(list, EquipStatusEnum.ONCAR.getCode());
        }
        return saveBatch;
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iEquipmentOnCarService.removeById(id);
    }


    /**
     * 修改
     *
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdEquipmentOnCar(HttpServletRequest request, @RequestBody EquipmentOnCar equipmentOnCar) {
        return iEquipmentOnCarService.updateById(equipmentOnCar);
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public EquipmentOnCar selectById(HttpServletRequest request, @PathVariable Long id) {
        return iEquipmentOnCarService.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<EquipmentOnCar> listPage(String pageNum, String pageSize,
                                          EquipmentOnCar equipmentOnCar) {

        Page<EquipmentOnCar> pageBean;
        QueryWrapper<EquipmentOnCar> equipmentOnCarQueryWrapper = new QueryWrapper<>();
        Class<? extends EquipmentOnCar> aClass = equipmentOnCar.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(equipmentOnCar);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(equipmentOnCar);
                        equipmentOnCarQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(equipmentOnCar);
                        equipmentOnCarQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(equipmentOnCar);
                        equipmentOnCarQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(equipmentOnCar);
                        equipmentOnCarQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<EquipmentOnCar> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iEquipmentOnCarService.page(pageBean, equipmentOnCarQueryWrapper);
        return page;
    }

    /**
     * 补码页面分页
     *
     * @return
     */
    @RequestMapping(value = "/page", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "列表分页查询", notes = "列表分页查询")
    public IPage<EquipmentOnCarVo> page(@RequestBody EquipmentOnCarDto equipmentOnCarDto) {
        return iEquipmentOnCarService.onCarIPage(equipmentOnCarDto);
    }
}


