package com.yeejoin.equipmanage.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.EquipmentPoint;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.service.IEquipmentPointService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;

/**
 *
 *
 * @author zhouyi
 * @date 2020-09-15
 */
@RestController
@Api(tags = "消防点位")
@RequestMapping(value = "/equipment-point", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipmentPointController extends AbstractBaseController{

    @Autowired
    private IEquipmentPointService iEquipmentPointService;

    /**
     * 列表分页查询
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<EquipmentPoint> listPage(String pageNum, String pageSize,
                                          EquipmentPoint equipmentPoint){

        if(equipmentPoint != null) {
            if(StringUtils.isBlank(equipmentPoint.getName())){
                equipmentPoint.setName(null);
            }
            if(StringUtils.isBlank(equipmentPoint.getType())){
                equipmentPoint.setType(null);
            }
        }

        Page<EquipmentPoint> pageBean;
        QueryWrapper<EquipmentPoint> equipmentpointQueryWrapper = new QueryWrapper<>();
        Class<? extends EquipmentPoint> aClass = equipmentPoint.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(equipmentPoint);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(equipmentPoint);
                        equipmentpointQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(equipmentPoint);
                        equipmentpointQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(equipmentPoint);
                        equipmentpointQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(equipmentPoint);
                        equipmentpointQueryWrapper.eq(name, fileValue);
                    }
                }
            }catch (Exception e) {
            }
        });
        IPage<EquipmentPoint> page;
        if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        }else{
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iEquipmentPointService.page(pageBean, equipmentpointQueryWrapper);
        return page;
    }

    /**
     * 新增
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveEquipmentPoint(HttpServletRequest request, @RequestBody EquipmentPoint equipmentPoint){
        equipmentPoint.setCreateBy(getUserId());
        equipmentPoint.setOrgCode(getOrgCode());
        return iEquipmentPointService.save(equipmentPoint);
    }

    /**
     * 根据id删除
     * @param id
     * @return
     */
    @RequestMapping(value = "delete/{id}", method = RequestMethod.DELETE)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iEquipmentPointService.removeById(id);
    }


    /**
     * 修改
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdEquipmentdefQrcode(HttpServletRequest request, @RequestBody EquipmentPoint equipmentPoint){
        return iEquipmentPointService.updateById(equipmentPoint);
    }



    /**
     * 根据id查询
     * @param id
     * @return
     */
    @RequestMapping(value = "/info/{id}", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public EquipmentPoint selectById(HttpServletRequest request, @PathVariable Long id){
        return iEquipmentPointService.getById(id);
    }
}
