package com.yeejoin.equipmanage.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.yeejoin.equipmanage.common.vo.CommonTreeVo;
import com.yeejoin.equipmanage.service.IFireResourceService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 消防资源
 * @author DELL
 */
@RestController
@Api(tags = "消防资源Api")
@RequestMapping(value = "/fireresource",produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class FireResourceController extends AbstractBaseController {

    @Autowired
    IFireResourceService iFireResourceService;


    @RequestMapping(value = "list",method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防资源树查询")
    public List<CommonTreeVo> getFireResourceTree(){
        return iFireResourceService.getFireResourceTree();
    }
}
