package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.dto.EquipSpecificAlarmDTO;

import java.util.List;
import java.util.Map;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.service
 * @ClassName: IEquipmentSpecificSerivceAlarm
 * @Author: Jianqiang Gao
 * @Description:
 * @Date: 2020/12/24 10:36
 * @Version: 1.0
 */
public interface IEquipmentSpecificSerivceAlarm extends IService<EquipmentSpecificAlarm> {

    /**
     * 根据时间、或类型、或状态获取告警信息（参数非必填）
     * createDate：例："2020-12-24"或"1"（今天）或"7"（近7天）或"30"（近30天）
     * type：例：FIREALARM，默认（FIREALARM OR BREAKDOWN OR SHIELD）
     * status：1报警0恢复
     * @param dto
     * @return
     */
    Map<String, List<EquipSpecificAlarmDTO>> findByTypeAndDate(EquipSpecificAlarmDTO dto);

    List<EquipSpecificAlarmDTO> findListByTypeAndDate(EquipSpecificAlarmDTO dto);

    List<EquipSpecificAlarmDTO> findInfoByTypeAndDate(EquipSpecificAlarmDTO dto);

}