package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.dto.OrgMenuDto;
import com.yeejoin.amos.feign.morphic.model.ResourceDTO;
import com.yeejoin.equipmanage.common.datasync.entity.FireFightingSystem;
import com.yeejoin.equipmanage.common.entity.FireFightingSystemEntity;
import com.yeejoin.equipmanage.common.entity.dto.EquipTypeAmountPageDTO;
import com.yeejoin.equipmanage.common.entity.vo.*;
import com.yeejoin.equipmanage.common.vo.*;

import java.util.List;
import java.util.Map;

public interface IFireFightingSystemService extends IService<FireFightingSystemEntity> {

    /**
     * 根据系统id查询设备列表
     *
     * @param systemId
     * @return
     */
    List<EquiplistSpecificBySystemVO> getEquiplistBySystemId(Long systemId);

    /**
     * 获取系列列表
     *
     * @param equimentName
     * @param equimentCode
     * @param construction
     * @param maintenance
     * @param current
     * @param pageSize
     * @return
     */
    Map<String, Object> queryEquipmenInfoAndCount(String equimentName, String equimentCode, String construction, String maintenance, String bizOrgCode, String formGroupId, int current, int pageSize);

    FireFightingSystemEntity getOneById(Long id);

    /**
     * 根据系统id查询分组设备数量
     *
     * @param systemId
     * @return
     */
    List<EquipCountBySystemVO> getEquipCountBySystemId(Long systemId);

    /**
     * 保存
     *
     * @param vo
     * @return
     */
    String save(FireFightingSystemVo vo);

    /**
     * 修改
     *
     * @param vo
     * @return
     */
    String update(FireFightingSystemVo vo);

    /**
     * 创建画布
     *
     * @param model 模型
     * @return RiskSourceScene
     */
    FireFightingSystemVo createMorphic(FireFightingSystemVo model);

    /**
     * 更新画布
     *
     * @param resourceDTO 参数
     */
    ResourceDTO updateMorphic(ResourceDTO resourceDTO);


    /**
     * 获得点位区域树
     *
     * @param orgCode
     * @return
     */
    List<PointTreeVo> getPointTree(String systemId, String orgCode);


    /**
     * 装备点性能指标接口
     *
     * @return
     */
    List<SpeIndexVo> getSpeIndex(Long id);

    /**
     * 列表查询
     *
     * @return List<FireFightingSystemEntity>
     */
    List<FireFightingSystemEntity> getList();

    /**
     * 获取详情
     *
     * @param id
     * @return
     */
    List<AlarmDataVO> getSystemById(Long id);

    IPage<EquipmentAlarmBySystemIdOrSourceIdVO> getEquipmentAlarmBySystemIdOrSourceIdVO(IPage<EquipmentAlarmBySystemIdOrSourceIdVO> page, Long sourceId, Long systemId, Integer confirmType, String createDate, String type);


    /**
     * 删除装备系统
     *
     * @param id
     * @return
     */
    Boolean deleteSystem(Long id);

    /**
     * 删除画布
     *
     * @param id
     * @return
     */
    Boolean isDeleteCanvas(Long id);

    IPage<EquipTypeImgAmountVO> getColaCategoryAmountList(int hierarchy, String codeHead, EquipTypeAmountPageDTO equipTypeAmountPage);

    IPage<EquipTypeImgAmountVO> getColaCategoryAmountListIot(int hierarchy, String codeHead, EquipTypeAmountPageDTO equipTypeAmountPage);
    IPage<EquipTypeImgAmountVO> getColaCategoryAmountCarList(int hierarchy, String codeHead, EquipTypeAmountPageDTO equipTypeAmountPage);

    IPage<EquipTypeImgAmountVO> getColaCategoryAmountEquList(int hierarchy, String codeHead, EquipTypeAmountPageDTO equipTypeAmountPage);


    /**
     * 获取消防系统在装备分类的定义
     *
     * @return List<EquipmentManageVo>
     */
    List<EquipmentManageVo> getSystemCategory();

    /**
     * 根据具体条件，获取消防系统详情
     *
     * @param fireFightingSystemVo
     * @return
     */
    List<FireFightingSystem> getFireFightingSystemDetail(FireFightingSystemVo fireFightingSystemVo);

    /**
     * 通过codes的数组，获取消防系统集合
     *
     * @param idsArr
     * @return
     */
    List<FireFightingSystemEntity> getFightingSysByCodes(String[] idsArr);

    List<FireFightingSystem3dVo> get3dFightingSystemList();

    /**
     * 按照code查询详情
     *
     * @param systemCode 系统编号
     * @return FireFightingSystemEntity
     */
    FireFightingSystemEntity getDetailByCode(String systemCode);

    /**
     * 集成页面系统数据
     *
     * @param systemCode 系统code
     * @param isUpdate   自动
     * @return Map<String, Object>
     */
    Map<String, Object> integrationPageSysData(String systemCode, Boolean isUpdate);

    /**
     * 根据bizOrgCode获取消防系统树
     *
     * @param bizOrgCode 登陆人的机构编码
     * @return list
     */
    List<FireFightingSystemTreeVo> getSystemTreeByOrgCode(String bizOrgCode);

    /**
     * 根据登录人及类型获取公司部门树
     *
     * @param type 默认查询公司及部门，公司：COMPANY，部门：DEPARTMENT
     * @return
     */
    List<OrgMenuDto> companyTreeByUserAndType(String type);

    /**
     * 获取消防系统类型树
     *
     * @return
     */
    List<FireFightingSystemTypeTreeVo> systemTypeTree(String bizOrgCode);

    /**
     * 获取列表不分页
     *
     * @param bizOrgCode orgCode
     * @return
     */
    List<FireFightingSystemEntity> systemListByBziOrgCode(String bizOrgCode);

    /**
     * 装备分类的类型和总数
     *
     * @param bizOrgCode
     * @return
     * @throws Exception
     */
    Object getEquipmentTypeAndCount(String bizOrgCode) throws Exception;

    /***
     * 车辆类型和统计值
     * @param bizOrgCode
     * @return
     * @throws Exception
     */
    Object getCarTypeAndCount(String bizOrgCode) throws Exception;

    Object refreshEquipmentTypeAndCount(String bizOrgCode) throws Exception;

    Object iotgetEquipmentTypeAndCount(String bizOrgCode) throws Exception;


    Object refreshCarTypeAndCount(String bizOrgCode) throws Exception;


}
