package com.yeejoin.equipmanage.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.DataNotFound;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.datasync.enums.VideoTypeEnum;
import com.yeejoin.equipmanage.common.entity.MonitorView;
import com.yeejoin.equipmanage.common.entity.dto.MonitorViewDto;
import com.yeejoin.equipmanage.common.entity.dto.MonitorViewTreeDto;
import com.yeejoin.equipmanage.common.entity.dto.MonitorViewVideoDto;
import com.yeejoin.equipmanage.common.entity.vo.VideoListVo;
import com.yeejoin.equipmanage.mapper.MonitorViewMapper;
import com.yeejoin.equipmanage.service.IVideoService;

/**
 * 
 * <pre>
 * 在岗监测视图  服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: MonitorViewService.java, v 0.1 2021年9月10日 下午7:32:18 gwb Exp $
 */
@Component
public class MonitorViewService
		extends BaseService<MonitorViewDto, MonitorView, MonitorViewMapper>
{

	@Autowired
	private MonitorViewVideoService monitorViewVideoService;
	
	@Autowired
	private IVideoService videoService;
	

	/**
	 * 
	 * <pre>
	 * 保存视频视图
	 * </pre>
	 *
	 * @param model
	 * @return
	 */
	public MonitorViewDto createMonitorView(MonitorViewDto model)
	{
		model = this.createWithModel(model);
		//保存视图与视频关联关系
		List<VideoListVo> videoList = model.getCheckedVideoDTOList();
		if (!ValidationUtil.isEmpty(videoList))
		{
			for (VideoListVo videoDTO : videoList)
			{
				MonitorViewVideoDto monitorViewVideoDto = new MonitorViewVideoDto();
				monitorViewVideoDto.setVideoId(Long.valueOf(videoDTO.getId()));
				monitorViewVideoDto.setViewId(model.getId());
				
				monitorViewVideoService.createWithModel(monitorViewVideoDto);
			}
		}
		
		return model;
	}

	/**
	 * 
	 * <pre>
	 * 更新视频视图
	 * </pre>
	 *
	 * @param model
	 * @param id
	 * @return
	 */
	public MonitorViewDto udpateMonitorView(MonitorViewDto model, Long id)
	{
		MonitorViewDto oldModel = this.queryBySeq(id);

		if (ValidationUtil.isEmpty(oldModel))
		{
			throw new DataNotFound("找不到视频视图信息");
		}
		Bean.copyExistPropertis(model, oldModel);
		this.updateWithModel(oldModel);
		
		//保存视图与视频关联关系
		monitorViewVideoService.deleteMonitorViewVideo(oldModel.getId());
		List<VideoListVo> videoList = model.getCheckedVideoDTOList();
		if (!ValidationUtil.isEmpty(videoList))
		{
			for (VideoListVo videoDTO : videoList)
			{
				MonitorViewVideoDto monitorViewVideoDto = new MonitorViewVideoDto();
				monitorViewVideoDto.setVideoId(Long.valueOf(videoDTO.getId()));
				monitorViewVideoDto.setViewId(model.getId());
				
				monitorViewVideoService.createWithModel(monitorViewVideoDto);
			}
		}
				
		return oldModel;
	}

	/**
	 * 
	 * <pre>
	 * 获取视频信息详情
	 * </pre>
	 *
	 * @param id
	 * @return
	 */
	public MonitorViewDto queryById(Long id)
	{
		MonitorViewDto model = this.queryBySeq(id);
		//填充视频信息
		List<VideoListVo> checkedVideoDTOList = new ArrayList<VideoListVo>();
		List<VideoListVo> uncheckedVideoDTOList = new ArrayList<VideoListVo>();
		
		List<MonitorViewVideoDto> monitorViewVideoList = monitorViewVideoService.queryAllForList();
		List<Long> videoIdList = new ArrayList<Long>();
		List<Long> viewVideoIdList = new ArrayList<Long>();
		for (MonitorViewVideoDto monitorViewVideoDto : monitorViewVideoList)
		{
			videoIdList.add(monitorViewVideoDto.getVideoId());
			if (id.equals(monitorViewVideoDto.getViewId()))
			{
				viewVideoIdList.add(monitorViewVideoDto.getVideoId());
			}
		}
		
		List<VideoListVo> videoList = videoService.listByType(VideoTypeEnum.BEHAVIOURAL.getName());
		for (VideoListVo videoListVo : videoList)
		{
			if (videoIdList.contains(videoListVo.getId()))
			{
				if (viewVideoIdList.contains(videoListVo.getId()))
				{
					checkedVideoDTOList.add(videoListVo);
				}
			}else 
			{
				uncheckedVideoDTOList.add(videoListVo);
			}
		}
		
		model.setCheckedVideoDTOList(checkedVideoDTOList);
		model.setUncheckedVideoDTOList(uncheckedVideoDTOList);
		return model;
	}

	/**
	 * 
	 * <pre>
	 * 批量删除视频信息
	 * </pre>
	 *
	 * @param ids
	 * @return
	 */
	public List<Long> deleteMonitorView(String ids)
	{
		List<Long> seqs = StringUtil.String2LongList(ids);
		for (Long seq : seqs)
		{
			if (!ValidationUtil.isEmpty(this.queryBySeq(seq)))
			{
				//删除视图与视频关联关系
				monitorViewVideoService.deleteMonitorViewVideo(seq);
				//删除视图信息
				this.deleteBySeq(seq);
			}
			else
			{
				throw new DataNotFound("找不到指定的视频视图");
			}
		}
		return seqs;
	}

	/**
	 * 
	 * <pre>
	 * 查询未绑定视图的视频列表
	 * </pre>
	 *
	 * @return
	 */
	public List<VideoListVo> queryUncheckedVideoList()
	{
		//填充视频信息
		List<VideoListVo> uncheckedVideoDTOList = new ArrayList<VideoListVo>();
		
		List<MonitorViewVideoDto> monitorViewVideoList = monitorViewVideoService.queryAllForList();
		List<Long> videoIdList = new ArrayList<Long>();
		for (MonitorViewVideoDto monitorViewVideoDto : monitorViewVideoList)
		{
			videoIdList.add(monitorViewVideoDto.getVideoId());
		}
		
		List<VideoListVo> videoList = videoService.listByType(VideoTypeEnum.BEHAVIOURAL.getName());
		for (VideoListVo videoListVo : videoList)
		{
			if (!videoIdList.contains(videoListVo.getId()))
			{
				uncheckedVideoDTOList.add(videoListVo);
			}
		}
		
		return uncheckedVideoDTOList;
	}
	
	/**
	 * 
	 * <pre>
	 * 查询视图下的视频列表
	 * </pre>
	 *
	 * @param viewId
	 * @return
	 */
	public Page<VideoListVo> queryVideoPageByViewId(Page<VideoListVo> page, Long nodeId,
			String nodeType)
	{
		//获取所有行为分析视频
		List<VideoListVo> videoList = videoService.listByType(VideoTypeEnum.BEHAVIOURAL.getName());
		Map<Long, VideoListVo> videoListVoMap = new HashMap<Long, VideoListVo>();
		for (VideoListVo videoListVo : videoList)
		{
			videoListVoMap.put(videoListVo.getId(), videoListVo);
		}
		List<VideoListVo> viewVideoList = new ArrayList<>();
		long total = 0;
		if (nodeType.equals("video") && !ValidationUtil.isEmpty(videoListVoMap.get(nodeId)))
		{
			viewVideoList.add(videoListVoMap.get(nodeId));
			total = 1;
		}else 
			if (nodeType.equals("view")) 
			{
				//分页获取视图下视频
				Page<MonitorViewVideoDto> monitorViewVideoDtos = monitorViewVideoService.queryForPage(page, nodeId);
				List<MonitorViewVideoDto> monitorViewVideoDtoList = monitorViewVideoDtos.getRecords();
				for (MonitorViewVideoDto monitorViewVideoDto : monitorViewVideoDtoList)
				{
					viewVideoList.add(videoListVoMap.get(monitorViewVideoDto.getVideoId()));
				}
				total = monitorViewVideoDtos.getTotal();
			}
		
		page.setRecords(viewVideoList);
		page.setTotal(total);
		return page;
	}
	
	/**
	 * 
	 * <pre>
	 * 查询视频信息树
	 * </pre>
	 *
	 * @return
	 * @throws Exception
	 */
	public List<MonitorViewTreeDto> queryForViewTree() throws Exception
	{
		List<MonitorViewTreeDto> returnList  = new ArrayList<>();
		//构建根节点
		MonitorViewTreeDto rootNode = new MonitorViewTreeDto();
		rootNode.setId(0L);
		rootNode.setTreeName("轮询视图");
		rootNode.setType("root");

		List<MonitorViewTreeDto> monitorViewTreeDtoList = new ArrayList<>();
		//获取所有行为分析视频
		List<VideoListVo> videoList = videoService.listByType(VideoTypeEnum.BEHAVIOURAL.getName());
		Map<Long, VideoListVo> videoListVoMap = new HashMap<Long, VideoListVo>();
		for (VideoListVo videoListVo : videoList)
		{
			videoListVoMap.put(videoListVo.getId(), videoListVo);
		}
		//视图填充视频列表
		List<MonitorViewVideoDto> monitorViewVideoList = monitorViewVideoService.queryAllForList();
		Map<Long, List<MonitorViewTreeDto>> viewVideoMap = new HashMap<Long, List<MonitorViewTreeDto>>();
		for (MonitorViewVideoDto monitorViewVideoDto : monitorViewVideoList)
		{
			List<MonitorViewTreeDto> videoListVoList = viewVideoMap.get(monitorViewVideoDto.getViewId());
			if (videoListVoList == null)
			{
				videoListVoList = new ArrayList<>(); 
			}
			VideoListVo videoListVo = videoListVoMap.get(monitorViewVideoDto.getVideoId());
			MonitorViewTreeDto monitorViewTreeDto = new MonitorViewTreeDto();
			monitorViewTreeDto.setId(videoListVo.getId());
			monitorViewTreeDto.setTreeName(videoListVo.getName());
			monitorViewTreeDto.setType("video");
			
			videoListVoList.add(monitorViewTreeDto);
			viewVideoMap.put(monitorViewVideoDto.getViewId(), videoListVoList);
		}
		List<MonitorViewDto> monitorViewDtoAll = this.queryForList("create_date", true);
		for (MonitorViewDto monitorViewDto : monitorViewDtoAll)
		{
			MonitorViewTreeDto monitorViewTreeDto = new MonitorViewTreeDto();
			monitorViewTreeDto.setId(monitorViewDto.getId());
			monitorViewTreeDto.setTreeName(monitorViewDto.getViewName());
			monitorViewTreeDto.setType("view");
			monitorViewTreeDto.setTotal(0);
			
			List<MonitorViewTreeDto> videoListVoList = viewVideoMap.get(monitorViewDto.getId());
			if (!ValidationUtil.isEmpty(videoListVoList))
			{
				monitorViewTreeDto.setTotal(videoListVoList.size());
			}
			monitorViewTreeDto.setChildren(videoListVoList);
			
			monitorViewTreeDtoList.add(monitorViewTreeDto);
		}

		rootNode.setChildren(monitorViewTreeDtoList);
		returnList.add(rootNode);
		return returnList;
	}
}
