package com.yeejoin.equipmanage.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.equipmanage.common.entity.Notice;
import com.yeejoin.equipmanage.common.enums.BillContentEnum;
import com.yeejoin.equipmanage.common.enums.NoticeEnum;
import com.yeejoin.equipmanage.mapper.NoticeMapper;
import com.yeejoin.equipmanage.service.ICarService;
import com.yeejoin.equipmanage.service.INoticeService;
import com.yeejoin.equipmanage.service.IWarehouseService;

/**
 * 服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class NoticeServiceImpl extends ServiceImpl<NoticeMapper, Notice> implements INoticeService {

	@Autowired
	private IWarehouseService warehouseService;

	@Autowired
	private ICarService carService;

	@Override
	public void saveEquipNotice(NoticeEnum noticeEnum, Long billId, String billCode) {
		saveNotice(noticeEnum, billId, billCode, BillContentEnum.ZB);

	}

	@Override
	public void saveCarNotice(NoticeEnum noticeEnum, Long billId, String billCode) {
		saveNotice(noticeEnum, billId, billCode, BillContentEnum.CL);
	}

	@Override
	public void saveNotice(NoticeEnum noticeEnum, Long billId, String billCode, BillContentEnum billContentEnum) {
		Notice notice = new Notice();
		notice.setStockBillId(billId);
		String title = noticeEnum.getName();
		String operate = title.replace("通知", "");
		AgencyUserModel user = Privilege.agencyUserClient.getme().getResult();
		String content = user.getRealName() + operate
				+ billContentEnum.getName() + "," + operate + "单据号【" + billCode
				+ "】";
		notice.setContent(content);
		notice.setTitle(title);
		notice.setNoticeTypeId(noticeEnum.getCode());
		save(notice);

	}
}
