package com.yeejoin.equipmanage.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.entity.Journal;
import com.yeejoin.equipmanage.common.entity.Repair;
import com.yeejoin.equipmanage.common.entity.RepairDetail;
import com.yeejoin.equipmanage.common.entity.StockDetail;
import com.yeejoin.equipmanage.common.enums.BillContentEnum;
import com.yeejoin.equipmanage.common.enums.CarStatusEnum;
import com.yeejoin.equipmanage.common.enums.EquipStatusEnum;
import com.yeejoin.equipmanage.common.enums.JournalTypeEnum;
import com.yeejoin.equipmanage.common.enums.NoticeEnum;
import com.yeejoin.equipmanage.mapper.RepairMapper;
import com.yeejoin.equipmanage.service.ICarService;
import com.yeejoin.equipmanage.service.IJournalService;
import com.yeejoin.equipmanage.service.INoticeService;
import com.yeejoin.equipmanage.service.IRepairDetailService;
import com.yeejoin.equipmanage.service.IRepairService;
import com.yeejoin.equipmanage.service.IStockBillService;
import com.yeejoin.equipmanage.service.IStockDetailService;

/**
 * 服务实现类
 *
 * @author wujiang
 * @date 2020-07-15
 */
@Service
public class RepairServiceImpl extends ServiceImpl<RepairMapper, Repair> implements IRepairService {

	@Autowired
	private IRepairDetailService repairDetailService;

	@Autowired
	private IStockDetailService stockDetailService;

	@Autowired
	private IJournalService journalService;

	@Autowired
	private INoticeService noticeService;

	@Autowired
	private IStockBillService stockBillService;

	@Autowired
	private ICarService carService;

	@Override
	public Repair exec(List<RepairDetail> list, String type, AgencyUserModel agencyUserModel) throws Exception {
		if (!type.equals("2")){
			for (int i = 0; i < list.size(); i++) {
				StockDetail stockDetail = stockDetailService.getById(list.get(i).getStockDetailId());
				if (stockDetail == null) {
					throw new Exception("查询库存失败，请联系管理员");
				}
				if (EquipStatusEnum.ONCAR.getCode().toString().equals(stockDetail.getStatus())) {
//					if(i == list.size()-1){
//						CZbuffer.append(stockDetail.getEquipmentDetail().getName());
//					}else{
//						CZbuffer.append(stockDetail.getEquipmentDetail().getName()).append(",");
//					}
					throw new Exception("请先在手机端卸载装备再进行维修或保养");
				}
			}


			//修改库存状态
			List<StockDetail> stockDetails = new ArrayList<>();
			list.forEach(x->{
				StockDetail stockDetail = new StockDetail();
				stockDetail.setId(x.getStockDetailId());
				stockDetail.setStatus(EquipStatusEnum.REPAIR.getCode().toString());
				stockDetails.add(stockDetail);
			});
			stockDetailService.updateBatchById(stockDetails);
		}
		Repair repair = new Repair();

		repair.setBillCode(stockBillService.generateQrCode("WX"));
		repair.setBillType(type);
		repair.setCreatorName(agencyUserModel.getRealName());
		this.save(repair);
		for (RepairDetail repairDetail : list) {
			if (BillContentEnum.CL.getCode().equals(type)) {
				repairDetail.setAmount(1.0);
			}
			repairDetail.setRepairId(repair.getId());
		}
		repairDetailService.saveBatch(list);
		if (BillContentEnum.ZB.getCode().equals(type)) {
			// wl_journal表
			saveEquipJournal(list, JournalTypeEnum.WX);
			updateEquipStatus(list, EquipStatusEnum.REPAIR);
			// warehouseId =
			// stockDetailService.getById(list.get(0).getStockDetailId()).getWarehouseId();
		} else {
			// wl_journal表
			saveCarJournal(list, JournalTypeEnum.WX);
			updateCarStatus(list, CarStatusEnum.WX);
		}
		// wl_notice表
		noticeService.saveNotice(NoticeEnum.REPAIR, repair.getId(), repair.getBillCode(),
				BillContentEnum.getEnum(type));
		return repair;
	}

	private void saveEquipJournal(List<RepairDetail> list, JournalTypeEnum journalTypeEnum) {
		List<Journal> journalList = new ArrayList<Journal>();
		for (RepairDetail repairDetail : list) {
			Journal journal = new Journal();
			StockDetail stockDetail = stockDetailService.getById(repairDetail.getStockDetailId());
			journal.setAmount(stockDetail.getAmount());
			journal.setEquipmentDetailId(stockDetail.getEquipmentDetailId());
			journal.setStockDetailId(stockDetail.getId());
			journal.setRemark(journalTypeEnum.getName());
			journal.setWarehouseStructureId(stockDetail.getWarehouseStructureId());
			journal.setState(journalTypeEnum.getCode());
			journalList.add(journal);
		}
		journalService.saveBatch(journalList);
	}

	private void updateEquipStatus(List<RepairDetail> list, EquipStatusEnum equipStatusEnum) {
		List<StockDetail> stockDetailList = new ArrayList<StockDetail>();
		for (RepairDetail repairDetail : list) {
			StockDetail stockDetail = stockDetailService.getById(repairDetail.getStockDetailId());
			stockDetail.setStatus(equipStatusEnum.getCode().toString());
			stockDetailList.add(stockDetail);
		}
		stockDetailService.updateBatchById(stockDetailList);
	}

	private void saveCarJournal(List<RepairDetail> list, JournalTypeEnum journalTypeEnum) {
		List<Journal> journalList = new ArrayList<Journal>();
		for (RepairDetail repairDetail : list) {
			Journal journal = new Journal();
			Car car = carService.getById(repairDetail.getCarId());
			journal.setAmount(1.0);
			journal.setCarId(car.getId());
			journal.setRemark(journalTypeEnum.getName());
			journal.setState(journalTypeEnum.getCode());
			journal.setCarId(car.getId());
			journalList.add(journal);
		}
		journalService.saveBatch(journalList);
	}

	private void updateCarStatus(List<RepairDetail> list, CarStatusEnum carStatusEnum) {
		List<Car> carList = new ArrayList<Car>();
		for (RepairDetail repairDetail : list) {
			Car car = carService.getById(repairDetail.getCarId());
			car.setCarState(carStatusEnum.getCode());
			carList.add(car);
		}
		carService.updateBatchById(carList);
	}

	@Override
	public Repair complete(List<RepairDetail> list, String type) {
		//修改库存状态
		List<StockDetail> stockDetails = new ArrayList<>();
		list.forEach(x->{
			StockDetail stockDetail = new StockDetail();
			stockDetail.setId(x.getStockDetailId());
			stockDetail.setStatus(EquipStatusEnum.REPERTORY.getCode().toString());
			stockDetails.add(stockDetail);
		});
		stockDetailService.updateBatchById(stockDetails);

		if (BillContentEnum.ZB.getCode().equals(type)) {
			// wl_journal表
			saveEquipJournal(list, JournalTypeEnum.WXWC);
			updateEquipStatus(list, EquipStatusEnum.REPERTORY);
		} else {
			// wl_journal表
			saveCarJournal(list, JournalTypeEnum.WXWC);
			updateCarStatus(list, CarStatusEnum.ZW);
		}
		return new Repair();
	}
}
