package com.yeejoin.equipmanage.service.impl;

import com.yeejoin.equipmanage.mapper.ScrapMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.entity.EquipmentDetail;
import com.yeejoin.equipmanage.common.entity.ScrapDetail;
import com.yeejoin.equipmanage.common.entity.StockDetail;
import com.yeejoin.equipmanage.mapper.ScrapDetailMapper;
import com.yeejoin.equipmanage.service.ICarService;
import com.yeejoin.equipmanage.service.IEquipmentDetailService;
import com.yeejoin.equipmanage.service.IScrapDetailService;
import com.yeejoin.equipmanage.service.IStockDetailService;

import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class ScrapDetailServiceImpl extends ServiceImpl<ScrapDetailMapper, ScrapDetail> implements IScrapDetailService {

	@Autowired
	private IStockDetailService iStockDetailService;

	@Autowired
	private IEquipmentDetailService iEquipmentDetailService;

	@Autowired
	private ICarService iCarService;

	@Autowired
	private ScrapMapper scrapMapper;

	@Override
	public ScrapDetail getOneById(Long id) {
		ScrapDetail scrapDetail = getById(id);
		StockDetail stockDetail = iStockDetailService.getById(scrapDetail.getStockDetailId());
		EquipmentDetail equipmentDetail = iEquipmentDetailService.getOneById(stockDetail.getEquipmentDetailId());
		stockDetail.setEquipmentDetail(equipmentDetail);
		scrapDetail.setStockDetail(stockDetail);
		return scrapDetail;
	}

	@Override
	public IPage<ScrapDetail> pageList(Page<ScrapDetail> pageBean, QueryWrapper<ScrapDetail> queryWrapper) {
		IPage<ScrapDetail> page = page(pageBean, queryWrapper);
		for (ScrapDetail scrapDetail : page.getRecords()) {
			if (scrapDetail.getStockDetailId() != null) {
				StockDetail stockDetail = iStockDetailService.getById(scrapDetail.getStockDetailId());
				EquipmentDetail equipmentDetail = iEquipmentDetailService
						.getOneById(stockDetail.getEquipmentDetailId());
				stockDetail.setEquipmentDetail(equipmentDetail);
				scrapDetail.setStockDetail(stockDetail);
				String img = equipmentDetail.getEquipment().getImg();
				if (img !=null && !"".equals(img)){
					scrapDetail.setImg(img);
				}
			} else if (scrapDetail.getCarId() != null) {
				Car car = iCarService.getById(scrapDetail.getCarId());
				scrapDetail.setCar(car);
				String img = scrapMapper.getImgById(scrapDetail.getScrapId(), "2");
				if (img != null && !"".equals(img)) {
					scrapDetail.setImg(img);
				}
			}

		}
		return page;
	}

	@Override
	public int getOneByQrcode(String qrCode) {
		return scrapMapper.getOneByQrcode(qrCode);
	}

	@Override
	public List<Map<String, Object>> geteqTypeAndAmount(Long id) {
		return scrapMapper.geteqTypeAndAmount(id);
	}

	@Override
	public int getCarByQrcode(String qrCode) {
		return scrapMapper.getCarByQrcode(qrCode);
	}
}
