package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.equipmanage.common.entity.*;
import com.yeejoin.equipmanage.common.entity.vo.StatisticsEquipCountVO;
import com.yeejoin.equipmanage.common.enums.BillContentEnum;
import com.yeejoin.equipmanage.common.enums.CarStatusEnum;
import com.yeejoin.equipmanage.common.enums.EquipStatusEnum;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.common.vo.EquipCategoryVo;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificMapper;
import com.yeejoin.equipmanage.mapper.StockDetailMapper;
import com.yeejoin.equipmanage.remote.RemoteSecurityService;
import com.yeejoin.equipmanage.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class StatisticsServiceImpl implements IStatisticsService {

	@Autowired
	private IWarehouseService warehouseService;
	@Autowired
	private ICarService carService;
	@Autowired
	private IStockDetailService stockDetailService;
	@Autowired
	private IEquipmentCategoryService iEquipmentCategoryService;
	@Autowired
	private IEquipmentService iEquipmentService;
	@Autowired
	private IEquipmentDetailService iEquipmentDetailService;
	@Autowired
	private StockDetailMapper stockDetailMapper;
	@Autowired
	private RemoteSecurityService remoteSecurityService;
	@Autowired
	private IFireFightingSystemService iFireFightingSystemService;
	@Autowired
	private EquipmentSpecificMapper equipmentSpecificMapper;

	@Override
	public Map<String, String> getAllCategoryBaseByWarehouseId(Long warehouseId) {
		Map<String, String> map = new HashMap<>();
		Warehouse warehouse = warehouseService.getById(warehouseId);
		String orgcode = warehouse.getOrgCode();
		// 查询装备总数
		List<Long> equipDetailIdList = getAllEquipDetailId();
		Integer count1 = stockDetailService
				.count(new QueryWrapper<StockDetail>().in("equipment_detail_id", equipDetailIdList)
						.eq("status", EquipStatusEnum.REPERTORY.getCode()).eq("warehouse_id", warehouseId));
		map.put(BillContentEnum.ZB.toString(), count1.toString());
		// 查询灭火药剂总数
		List<Long> extinguishingDetailIdList = getAllExtinguishingDetailId();
		List<StockDetail> stockDetailList = new ArrayList<>();
		if(!CollectionUtils.isEmpty(extinguishingDetailIdList)){
			//2020-09-03 解决extinguishingDetailIdList为空sql报错问题(增加判断)
			stockDetailList = stockDetailService.list(new QueryWrapper<StockDetail>()
					.in("equipment_detail_id", extinguishingDetailIdList).eq("warehouse_id", warehouseId)
					.eq("status", EquipStatusEnum.REPERTORY.getCode()).or().eq("status", EquipStatusEnum.ONCAR.getCode()));
		}
		
		Double count2 = 0.0;
		for (StockDetail stockDetail : stockDetailList) {
			count2 += stockDetail.getAmount();
		}
		map.put(BillContentEnum.MHYJ.toString(), count2.toString());
		// 查询车辆总数
		QueryWrapper<Car> carQueryWrapper = new QueryWrapper<Car>();
		carQueryWrapper.eq("org_code", orgcode);
		carQueryWrapper.ne("car_state", CarStatusEnum.BF.getCode());
		Integer count3 = carService.count(carQueryWrapper);
		map.put(BillContentEnum.CL.toString(), count3.toString());
		// 查询人总数
		List<DictionarieValueModel> dic = remoteSecurityService.listDictionaryByDictCode("DEPARTMENT_IDS");
		int i = 0;
		if (0 < dic.size()) {
			for (DictionarieValueModel item : dic) {
				if (StringUtil.isNotEmpty(item.getDictDataValue())) {
					List<AgencyUserModel> agencyUserModels = remoteSecurityService.listUserByDepartmentId(Long.valueOf(item.getDictDataValue()));
					i += agencyUserModels.size();
				}
			}
		}
		map.put(BillContentEnum.RY.toString(), String.valueOf(i));
		return map;
	}

	private List<Long> getAllEquipDetailId() {
		List<EquipmentCategory> categoryList = iEquipmentCategoryService
				.list(new QueryWrapper<EquipmentCategory>().likeRight("code", "1").or().likeRight("code", "3").or()
						.likeRight("code", "5").or().likeRight("code", "6").or().likeRight("code", "7").or()
						.likeRight("code", "8").or().likeRight("code", "9"));
		List<Long> categoryIdList = new ArrayList<Long>();
		for (EquipmentCategory category : categoryList) {
			categoryIdList.add(category.getId());
		}
		return getDetailIdByCategoryId(categoryIdList);
	}

	private List<Long> getAllExtinguishingDetailId() {
		List<EquipmentCategory> categoryList = iEquipmentCategoryService
				.list(new QueryWrapper<EquipmentCategory>().likeRight("code", "4"));
		List<Long> categoryIdList = new ArrayList<Long>();
		for (EquipmentCategory category : categoryList) {
			categoryIdList.add(category.getId());
		}
		return getDetailIdByCategoryId(categoryIdList);
	}

	private List<Long> getDetailIdByCategoryId(List<Long> categoryIdList) {
		List<Long> detailIdList = new ArrayList<Long>();
		List<Equipment> equipmentList = iEquipmentService
				.list(new QueryWrapper<Equipment>().in("category_id", categoryIdList));
		if (equipmentList.isEmpty()) {
			return detailIdList;
		}
		List<Long> equipmentIdList = new ArrayList<Long>();
		for (Equipment equipment : equipmentList) {
			equipmentIdList.add(equipment.getId());
		}
		List<EquipmentDetail> equipmentDetailList = iEquipmentDetailService
				.list(new QueryWrapper<EquipmentDetail>().in("equipment_id", equipmentIdList));
		for (EquipmentDetail equipmentDetail : equipmentDetailList) {
			detailIdList.add(equipmentDetail.getId());
		}
		return detailIdList;
	}

	@Override
	public Map<String, String> getEquipmentStatusByWarehouseId(Long warehouseId) {
		Map<String, String> map = new HashMap<>();
		List<Long> equipDetailIdList = getAllEquipDetailId();
		Integer count1 = stockDetailService
				.count(new QueryWrapper<StockDetail>().in("equipment_detail_id", equipDetailIdList)
						.eq("status", EquipStatusEnum.REPERTORY.getCode()));
		Integer count2 = stockDetailService
				.count(new QueryWrapper<StockDetail>().in("equipment_detail_id", equipDetailIdList)
						.eq("status", EquipStatusEnum.REPAIR.getCode()));
		Integer count3 = stockDetailService
				.count(new QueryWrapper<StockDetail>().in("equipment_detail_id", equipDetailIdList)
						.eq("status", EquipStatusEnum.SCRAP.getCode()));
		Integer count4 = count1 + count2;
		map.put(EquipStatusEnum.REPERTORY.toString(), count1.toString());
		map.put(EquipStatusEnum.REPAIR.toString(), count2.toString());
		map.put(EquipStatusEnum.SCRAP.toString(), count3.toString());
		map.put("ALL", count4.toString());
		return map;
	}

	@Override
	public Map<String, String> getCarCategoryByOrgcode(String orgcode) {
		Map<String, String> map = new HashMap<>();
		// 灭火类消防车
		map.put("MH", getCarCountByCategory("21010100", orgcode).toString());
		// 举高类消防车
		map.put("JG", getCarCountByCategory("21010200", orgcode).toString());
		// 专勤类消防车
		map.put("ZQ", getCarCountByCategory("21010300", orgcode).toString());
		// 战勤保障类消防车
		map.put("ZQBZ", getCarCountByCategory("21010400", orgcode).toString());
		return map;
	}

	private Integer getCarCountByCategory(String categoryCode, String orgcode) {
		EquipmentCategory category= iEquipmentCategoryService
				.getOne(new QueryWrapper<EquipmentCategory>().eq("code", categoryCode));
		List<EquipmentCategory> categoryList= iEquipmentCategoryService
				.list(new QueryWrapper<EquipmentCategory>().eq("parent_id", category.getId()));
		List<Long> categoryIdList = new ArrayList<Long>();
		for (EquipmentCategory categorys : categoryList) {
			categoryIdList.add(categorys.getId());
		}
		List<Equipment> equipmentList = iEquipmentService
				.list(new QueryWrapper<Equipment>().in("category_id", categoryIdList));
		List<Long> equipmentIdList = new ArrayList<Long>();
		for (Equipment equipment : equipmentList) {
			equipmentIdList.add(equipment.getId());
		}
		QueryWrapper<Car> carQueryWrapper = new QueryWrapper<>();
		carQueryWrapper.ne("car_state", CarStatusEnum.BF.getCode());
		if(equipmentIdList.size()>0){
			carQueryWrapper.in("equipment_id", equipmentIdList);
			if(!StringUtils.isEmpty(orgcode)){
				carQueryWrapper.in("org_code", orgcode);
			}
			return carService.count(carQueryWrapper);
		}else{
			return 0;
		}
	}

	@Override
	public Map<String, String> getExtinguishingCategoryByWarehouseId(Long warehouseId) {

		Map<String, String> map = new HashMap<>();
		List<StatisticsEquipCountVO> statisticsEquipCount = stockDetailMapper.getStatisticsEquipCount();
		statisticsEquipCount.forEach(x->{
			map.put(x.getCode(),String.valueOf(x.getSum()));
		});
		return map;
	}

	@Override
	public List<EquipCategoryVo> equipCategoryVoList(String systemCode) {
		List<FireFightingSystemEntity> fireFightingSystemEntities = iFireFightingSystemService.list(new LambdaQueryWrapper<FireFightingSystemEntity>().eq(FireFightingSystemEntity::getCode,systemCode));
		if(fireFightingSystemEntities.isEmpty()){
			return new ArrayList<>();
		}
		FireFightingSystemEntity fightingSystemEntity = fireFightingSystemEntities.get(0);
		return equipmentSpecificMapper.selectEquipCategoryNumber(fightingSystemEntity.getId());
	}

	private Double getExtinguishingCountByWarehouseId(String categoryCode, Long warehouseId) {
		List<EquipmentCategory> categoryList = iEquipmentCategoryService
				.list(new QueryWrapper<EquipmentCategory>().eq("code", categoryCode));
		List<Long> categoryIdList = new ArrayList<Long>();
		for (EquipmentCategory category : categoryList) {
			categoryIdList.add(category.getId());
		}
		List<Long> equipmentDetailIdList = getDetailIdByCategoryId(categoryIdList);
		Double count = 0.0;
		if (equipmentDetailIdList.isEmpty()) {
			return count;
		}
		List<StockDetail> list = stockDetailService.list(new QueryWrapper<StockDetail>()
				.in("equipment_detail_id", equipmentDetailIdList).eq("warehouse_id", warehouseId)
				.eq("status", EquipStatusEnum.REPERTORY.getCode()).or().eq("status", EquipStatusEnum.ONCAR.getCode()));
		for (StockDetail stockDetail : list) {
			count += stockDetail.getAmount();
		}
		return count;
	}
}
