package com.yeejoin.equipmanage.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.equipmanage.common.entity.dto.StockBillDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.Maintain;
import com.yeejoin.equipmanage.common.entity.Repair;
import com.yeejoin.equipmanage.common.entity.Scrap;
import com.yeejoin.equipmanage.common.entity.StockBill;
import com.yeejoin.equipmanage.mapper.StockBillMapper;
import com.yeejoin.equipmanage.service.IMaintainService;
import com.yeejoin.equipmanage.service.IRepairService;
import com.yeejoin.equipmanage.service.IScrapService;
import com.yeejoin.equipmanage.service.IStockBillService;

/**
 * 服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class StockBillServiceImpl extends ServiceImpl<StockBillMapper, StockBill> implements IStockBillService {

	@Autowired
	private IRepairService repairService;

	@Autowired
	private IScrapService scrapService;

	@Autowired
	private IMaintainService maintainService;

	@Override
	public String generateQrCode(String key) {
		String today = new SimpleDateFormat("yyyyMMdd").format(new Date());
		String prefix = key + today;
		String suffix = null;
		if ("RK".equals(key)) {
			StockBill stockBill = this.getOne(new QueryWrapper<StockBill>().likeRight("bill_code", prefix)
					.orderByDesc("bill_code").last("LIMIT 1"));
			if (stockBill != null) {
				suffix = stockBill.getBillCode().substring(prefix.length() + 1, stockBill.getBillCode().length());
			}
		} else if ("BY".equals(key)) {
			Maintain maintain = maintainService.getOne(new QueryWrapper<Maintain>().likeRight("bill_code", prefix)
					.orderByDesc("bill_code").last("LIMIT 1"));
			if (maintain != null) {
				suffix = maintain.getBillCode().substring(prefix.length() + 1, maintain.getBillCode().length());
			}
		} else if ("WX".equals(key)) {
			Repair repair = repairService.getOne(
					new QueryWrapper<Repair>().likeRight("bill_code", prefix).orderByDesc("bill_code").last("LIMIT 1"));
			if (repair != null) {
				suffix = repair.getBillCode().substring(prefix.length() + 1, repair.getBillCode().length());
			}
		} else if ("BF".equals(key)) {
			Scrap scrap = scrapService.getOne(
					new QueryWrapper<Scrap>().likeRight("bill_code", prefix).orderByDesc("bill_code").last("LIMIT 1"));
			if (scrap != null) {
				suffix = scrap.getBillCode().substring(prefix.length() + 1, scrap.getBillCode().length());
			}
		}
		String billCode;
		if (suffix != null) {
			int i = Integer.valueOf(suffix);
			billCode = prefix + "-" + ++i;
		} else {
			billCode = prefix + "-" + 1;
		}
		return billCode;
	}

	@Override
	public IPage<StockBill> selectAllBill(IPage page, StockBillDTO stockBillDTO) {
		return this.baseMapper.selectAllBill(page,stockBillDTO);
	}

}
