package com.yeejoin.amos.fas.business.action;

import com.yeejoin.amos.component.rule.RuleActionBean;
import com.yeejoin.amos.component.rule.RuleMethod;
import com.yeejoin.amos.fas.business.action.result.ActionResult;
import com.yeejoin.amos.fas.business.action.result.BubbleTipResult;
import com.yeejoin.amos.fas.business.action.result.message.ActionResultMessage;
import org.springframework.stereotype.Component;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * <pre>
 * 气泡提示动作
 * </pre>
 *
 * @author amos
 * @version $Id: BubbleTipAction.java, v 0.1 2019年5月16日 上午10:42:32 amos Exp $
 */
@Component
@RuleActionBean(beanLabel = "气泡提示" )
public class BubbleTipAction implements CustomerAction
{
	private static String PACKAGEURL = "com.yeejoin.amos.fas.business.action.result.message.";


	//@ExposeAction("气泡提示")
	@RuleMethod(methodLabel = "气泡提示", project = "风险管控")
	public void sendBubbleTip(Object bizobj, Boolean showInfo, Object title, String type)
	{
		BubbleTipResult result = new BubbleTipResult();
		Map<String, Object> tempmap1 = new HashMap<>();
		tempmap1.put("bizobj", bizobj);
		result.add(tempmap1);
		//是否显示气泡
		Map<String, Object> tempmap2 = new HashMap<>();
		tempmap2.put("showInfo", showInfo);
		result.add(tempmap2);
		//显示title提示
		Map<String, Object> tempmap3 = new HashMap<>();
		tempmap3.put("title", title);
		result.add(tempmap3);
		//节点类型
		Map<String, Object> tempmap4 = new HashMap<>();
		tempmap4.put("type", type);
		result.add(tempmap4);

		Constructor<?> constructor;
		try
		{
			constructor = Class.forName(
					PACKAGEURL + result.getClass().getSimpleName() + "Message")
					.getConstructor(ActionResult.class);
			ActionResultMessage<?> action = (ActionResultMessage<?>) constructor.newInstance(result);
			String msgType = "message";
			Object obj = action.execute(msgType, null);
//			result.setToipResponse((ToipResponse) obj);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	@Override
	public void intreeuptPlan(String batchNo) {

	}
}
