package com.yeejoin.amos.fas.business.action.model;
import java.util.List;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;

import lombok.Data;


@RuleFact(value = "巡检点",project = "风险管控")
@Data
public class ProtalDataRo extends BasicsRo {

    private static final long serialVersionUID = -1029442967802232959L;
    @Label("巡检点id")
    private Long id;//巡检点id
    @Label("巡检点名称")
    private String name; //名称
    @Label("状态")
    private String nodeState;//实时状态
    @Label("上一次状态")
    private String originalNodeState;//记录状态状态
    
    private String level;//巡检点级别


    /**
     * 巡检点编号
     */
    @Label("巡检点编号")
    private String pointNo;
    /**
     * 责任人
     */
    @Label("责任人")
    private String userName;

    /**
     * 巡检人员
     */
    
    private String checkUser;

    /**
     * 任务编号，如果无任务，则填充0
     */
    @Label("任务id")
    private Long taskId= 0L;
    /**
     * 任务状态
     */
    @Label("任务状态")
    private Integer taskState;
    /**
     * 上一次任务状态
     */
    @Label("上一次任务状态")
    private String originalTaskState;


    private String taskName;//任务名称


    private String content;//内容

    private String pointName;//巡检点名称
    @Label("当前时间")
    private String currTime;//当前时间



	private List<CheckInputItemRo> items;

    private List<CheckInputItemRo> pointInputitems;
}