package com.yeejoin.amos.knowledgebase.face.orm.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowlegeStatisticsRecord;

import java.util.List;
import java.util.Map;

/**
 * <p>
  * 标签分组 Mapper 接口
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
public interface StatisticsRecordMapper extends BaseMapper<KnowlegeStatisticsRecord> {

    /**
     * 表清空
     * @return
     */
    void deleteAll();

    /**
     * 查询灾情总计
     * @return
     */
    Map<String, Object> selectDisasterCount();

    /**
     * 按类型分组查询
     */
    List<Map<String, Object>> selectCategoryByName(String recordName);

    /**
     * 按类型查询/按时间分段总计
     */
    List<Map<String, Object>> selectCountByNameAndDateRange(Map<String, Object> queryMap);

}