package com.yeejoin.amos.knowledgebase.face.service;


import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.knowledgebase.face.enumeration.OperateType;
import com.yeejoin.amos.knowledgebase.face.feign.RemoteData;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDocCommentsModel;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeInteractionRecordModel;
import com.yeejoin.amos.knowledgebase.face.orm.dao.DocCommentsMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeDocComments;


/**
 * <p>
 * 知识库评论信息 服务类
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@Component
public class DocCommentsService extends BaseService<KnowledgeDocCommentsModel, KnowledgeDocComments, DocCommentsMapper> {


    public static final Long ROOT = 0L;

    @Autowired
    private InteractionRecordService interactionRecordService;
    /**
     * @author 杨博超
     * @description 创建评论信息
     * @Param [commentsModel]
     * @return com.yeejoin.amos.knowledgebase.face.model.KnowledgeDocCommentsModel
     **/
    public KnowledgeDocCommentsModel createComments(KnowledgeDocCommentsModel commentsModel) {
        commentsModel.setAgencyCode(RequestContext.getAgencyCode());
        commentsModel.setUserId(RequestContext.getExeUserId());
        if (ValidationUtil.isEmpty(commentsModel.getParentId())) {
            commentsModel.setParentId(ROOT);
        }

        return this.createWithModel(commentsModel);
    }


    /**
     * @return boolean
     * @author 杨博超
     * @description 给评论点赞
     * @Param [sequenceNbr]
     **/
    public boolean like(Long sequenceNbr) {

        KnowledgeInteractionRecordModel recordModel = createLikeRecord(sequenceNbr);
        KnowledgeInteractionRecordModel oldModel = interactionRecordService.queryUniqueModel(recordModel.getUserId(),recordModel.getEntityType(),recordModel.getEntityId(),recordModel.getOperateType());
        if (!ValidationUtil.isEmpty(oldModel)) {
            interactionRecordService.deleteInteractionRecord(oldModel);
        } else {
            interactionRecordService.createInteractionRecord(recordModel);
        }
        return true;
    }

    /**
     * 获取文档的评论总数
     * @param docSeq
     * @return
     */
    public int getCommentsTotal(Long docSeq) {
        return this.queryCount(docSeq);
    }
    

    /** 分页查询文档评论 */
    public Page queryDocCommentsPage(Page page, String agencyCode,Long docSeq) {
        Page commentsPage = this.queryForPage(page, "REC_DATE", false, agencyCode, docSeq);
        List<KnowledgeDocCommentsModel> records = commentsPage.getRecords();
        if (!ValidationUtil.isEmpty(records)) {
            for (KnowledgeDocCommentsModel commentsModel : records) {
                setLikeAndCount(commentsModel);
            }
        }
        return commentsPage;
    }

    private KnowledgeInteractionRecordModel createLikeRecord(Long sequenceNbr){
        KnowledgeInteractionRecordModel recordModel = new KnowledgeInteractionRecordModel();
        recordModel.setAgencyCode(RequestContext.getAgencyCode());
        recordModel.setUserId(RequestContext.getExeUserId());
        recordModel.setEntityType(KnowledgeDocCommentsModel.class.getSimpleName());
        recordModel.setEntityId(String.valueOf(sequenceNbr));
        recordModel.setOperateType(OperateType.LIKE.name());
        recordModel.setRecUserId(RequestContext.getExeUserId());
        recordModel.setRecDate(new Date());
        return recordModel;
    }

    private void setLikeAndCount (KnowledgeDocCommentsModel commentsModel){
        KnowledgeInteractionRecordModel recordModel = createLikeRecord(commentsModel.getSequenceNbr());
        KnowledgeInteractionRecordModel oldRecordModel = interactionRecordService.queryUniqueModel(recordModel.getUserId(),recordModel.getEntityType(),recordModel.getEntityId(),recordModel.getOperateType());
        int likedNum = interactionRecordService.countByInstance(OperateType.LIKE.name(), KnowledgeDocCommentsModel.class.getSimpleName(), commentsModel.getSequenceNbr().toString());
        commentsModel.setLike(!ValidationUtil.isEmpty(oldRecordModel));
        commentsModel.setLikedNum(likedNum);
        // 加入用户姓名
        commentsModel.setUsername(RemoteData.getUserRealNamById(commentsModel.getUserId()));
    }

}
