package com.yeejoin.amos.knowledgebase.face.service;


import com.yeejoin.amos.knowledgebase.face.enumeration.DynamicsFunctional;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDynamicsGroupModel;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDynamicsOptionModel;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDynamicsValueModel;
import com.yeejoin.amos.knowledgebase.face.orm.dao.DynamicsOptionMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeDynamicsOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.exception.instance.DataNotFound;

import java.util.List;


/**
 * <p>
 * 知识库系统动态选项配置，多用于动态字段配置 服务类
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@Component
public class DynamicsOptionService extends BaseService<KnowledgeDynamicsOptionModel, KnowledgeDynamicsOption, DynamicsOptionMapper> {


    @Autowired
    private DynamicsGroupService dynamicsGroupService;


    @Autowired
    private DynamicsValueService dynamicsValueService;

    public KnowledgeDynamicsOptionModel createOption(KnowledgeDynamicsOptionModel model) {

        model.setAgencyCode(RequestContext.getAgencyCode());
        model.setFunctional(DynamicsFunctional.DOC_BASEINFO.name());
        if (ValidationUtil.isEmpty(model.getQueryStrategy())) {
            model.setQueryStrategy(Operator.eq.name());
        }
        model = fillGroupInfo(model);

        return this.createWithModel(model);
    }


    public KnowledgeDynamicsOptionModel udpateOption(KnowledgeDynamicsOptionModel model) {

        KnowledgeDynamicsOptionModel oldModel = this.queryBySeq(model.getSequenceNbr());
        if (ValidationUtil.isEmpty(oldModel)) {
            throw new DataNotFound("找不到制定的动态字段.");
        }

        oldModel = Bean.copyExistPropertis(model, oldModel);
        oldModel = fillGroupInfo(oldModel);
        return this.updateWithModel(oldModel);
    }

    public boolean deleteOption(Long sequenceNbr) {

        KnowledgeDynamicsOptionModel oldModel = this.queryBySeq(sequenceNbr);
        if (ValidationUtil.isEmpty(oldModel)) {
            throw new DataNotFound("找不到制定的动态字段.");
        }

        List<KnowledgeDynamicsValueModel> valueModels = dynamicsValueService.queryByOptionSeq(oldModel.getSequenceNbr());
        if (!ValidationUtil.isEmpty(valueModels)) {
            throw new BadRequest("字段已经被引用.");
        }

        this.deleteBySeq(oldModel.getSequenceNbr());
        return true;
    }


    /**
     * @return com.yeejoin.amos.knowledgebase.face.model.KnowledgeDynamicsOptionModel
     * @author 杨博超
     * @description 填充字段分组信息.
     * @Param [model]
     **/
    private KnowledgeDynamicsOptionModel fillGroupInfo(KnowledgeDynamicsOptionModel model) {
        KnowledgeDynamicsGroupModel groupModel = dynamicsGroupService.queryBySeq(model.getGroupSeq());
        if (ValidationUtil.isEmpty(groupModel)) {
            throw new BadRequest("字段分组不存在.");
        }

        if (!groupModel.getAppKey().equals(RequestContext.getAppKey())) {
            throw new BadRequest("分组选择有误.");
        }

        model.setFunctional(groupModel.getFunctional());
        model.setAppKey(groupModel.getAppKey());
        return model;
    }


    /**
     * @return java.util.List<com.yeejoin.amos.knowledgebase.face.model.KnowledgeDynamicsOptionModel>
     * @author 杨博超
     * @description 根据分组编号获取
     * @Param [groupCode]
     **/
    public List<KnowledgeDynamicsOptionModel> queryByFunctional( String appKey, String functional) {
        return this.queryForList("", false, appKey, functional);
    }


    public List<KnowledgeDynamicsOptionModel> queryByGroupSeq(Long groupSeq) {
        return this.queryForList("", false, groupSeq);
    }


}
