package com.yeejoin.amos.latentdanger.business.dao.mapper;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.latentdanger.business.entity.mybatis.CheckMsgBo;
import com.yeejoin.amos.latentdanger.business.entity.mybatis.PushTargetBo;
import org.apache.ibatis.annotations.Param;

public interface MsgMapper extends BaseMapper{
	
	public List<PushTargetBo> getAppPushTargetBo(@Param(value="userId")String userId, @Param(value="checkType")String checkType,
												 @Param(value="routeId")Long routeId);
	
	public List<PushTargetBo> getEmailPushTargetBo(@Param(value="userId")String userId, @Param(value="checkEmail")String checkEmail, 
			@Param(value="routeId")Long routeId);
	
	public List<PushTargetBo> getPushUserBo(@Param(value="type")String type, @Param(value="userIds")String userIds,  
			@Param(value="routeId")Long routeId, @Param(value="checkType")String checkType);
	
	/**
	 * 根据巡检id获取巡检详情
	 * @param checkId
	 * @return
	 */
	public CheckMsgBo getCheckMsgBos(@Param(value="checkId")Long checkId);
	
	/**
	 * 根据巡检记录ID获取对应点和路线的负责人ID
	 * 
	 * @param checkId
	 * @return
	 */
	public Map<String, Object> getChargerId(@Param(value="checkId")Long checkId);
	
	/**
	 * 根据巡检记录ID获取对应点和路线的负责人ID
	 * 
	 * @param checkId
	 * @return
	 */
	public List getChargerIds(@Param(value="checkId")Long checkId);
}
