package com.yeejoin.amos.maintenance.business.feign;

import com.yeejoin.amos.maintenance.business.entity.mybatis.DangerResultBo;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.core.common.response.PointCheckInfoBusinessRespone;
import com.yeejoin.amos.maintenance.core.common.response.TaskInfoBusinessRespone;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
@FeignClient(name = "${Business.fegin.name}",configuration=FeignConfiguration.class)
public interface Business {

	@RequestMapping(value = "/fireAutoSys/api/risksource/data/patroldata", method = RequestMethod.PUT)
	CommonResponse checkStatusPushToB( @RequestBody PointCheckInfoBusinessRespone pb);

    @RequestMapping(value = "/fireAutoSys/api/risksource/data/task", method = RequestMethod.PUT)
    CommonResponse errorTaskPushToB( @RequestBody TaskInfoBusinessRespone tb);

    /**
     * 通知统计数据刷新
     * @param dataType 类型
     * @return 空
     */
    @GetMapping(value = "/fireAutoSys/api/data/refresh/{dataType}")
    CommonResponse planTaskInsertToB(@PathVariable (value="dataType") String dataType);

    /**
      * <pre>
      * @Description: 隐患治理完成更新rpn值
      * </pre>
      *
      * @MethodName:
      * @Param:
      * @Return: null
      * @Throws
      * @Author keyong
      * @Date 2021/2/4 20:55
      */
    @PostMapping(value = "/fireAutoSys/api/risksource/data/danger/state")
    CommonResponse processProtalDataFromDanger(@RequestBody DangerResultBo data);
}