package com.yeejoin.amos.maintenance.business.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author DELL
 */
@Data
@NoArgsConstructor
@ApiModel(value = "任务提交")
public class CheckRecordParam {

	@ApiModelProperty(value = "任务id",required = true)
	private Long planTaskId;

	@ApiModelProperty(value = "点id",required = true)
	private Long pointId;

    @ApiModelProperty(value = "组织机构")
    private String orgCode;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "路线id")
	private Long routeId;

	@ApiModelProperty(value = "检查时间")
	private String checkTime;

	/**
	 * 检查项
	 */
	@ApiModelProperty(value = "检查项",required = true)
	private List<CheckInputParam> checkItems = new ArrayList<>();
}
