package com.yeejoin.amos.maintenance.email;

public interface IEmailService {
	 
	/**
     * 发送简单邮件
     * @param to 收件人
     * @param subject 标题
     * @param content 内容
     */
	 public void sendSimpleEmail(String to, String subject, String content);
	 
	 /**
     * 发送简单邮件
     * @param to String[] 收件人
     * @param subject 标题
     * @param content 内容
     */
	 public void sendSimpleEmail(String[] to, String subject, String content);
	 
    /**
     * 发送html格式邮件
     * @param to
     * @param subject
     * @param content
     */
    public void sendHtmlEmail(String to, String subject, String content);
    /**
     * 发送带附件的邮件
     * @param to
     * @param subject
     * @param content
     * @param filePath
     */
    public void sendAttachmentsEmail(String to, String subject, String content, String filePath);
    /**
     * 发送带静态资源的邮件
     * @param to
     * @param subject
     * @param content
     * @param rscPath
     * @param rscId
     */
    public void sendInlineResourceEmail(String to, String subject, String content, String rscPath, String rscId);
}
