package com.yeejoin.amos.patrol.business.service.intfc;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.patrol.business.entity.mybatis.CheckPtListBo;
import com.yeejoin.amos.patrol.business.param.*;
import com.yeejoin.amos.patrol.business.util.DaoCriteria;
import com.yeejoin.amos.patrol.business.vo.LeavelMovePointVo;
import com.yeejoin.amos.patrol.business.vo.PointClassifyVo;
import com.yeejoin.amos.patrol.business.vo.PointInputItemVo;
import com.yeejoin.amos.patrol.business.vo.PointVo;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.response.PointResponse;
import com.yeejoin.amos.patrol.dao.entity.Point;
import com.yeejoin.amos.patrol.dao.entity.PointClassify;
import com.yeejoin.amos.patrol.dao.entity.PointPhoto;
import org.springframework.data.domain.Page;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface IPointService {

    /**
     * 添加巡检点
     *
     * @param point
     */
    Point addPoint(PointParam point);

    /**
     * 添加巡检点
     *
     * @param point
     */
    Point newAddPoint(NewPointParam point);
    /**
     * 删除巡检点。返回成功删除点的ID
     *
     * @param ids
     */
    List<Long> delPointById(Long[] ids);

    /**
     * 维护点信息
     *
     * @param pointParam
     */
    Point updatePoint(PointParam pointParam);

    /**
     * 维护点信息
     *
     * @param newPointParam
     */
    Point updatePointNew(NewPointParam newPointParam);
    /**
     * 巡检点另存为
     *
     * @param pointIds
     */
    void saveAs(Long[] pointIds);

    /**
     * 导入巡检点
     */
    void importPoint();

    /**
     * 导出巡检点
     */
    void exportPoint();

    /**
     * 根据点ID查询点信息
     */
    Point queryPointById(Long id);

    /**
     * 查询巡检点信息
     */
    Page<List<Point>> queryPointInfoPage(List<DaoCriteria> criterias);

    /**
     * 巡检点信息查询
     *
     * @param criterias
     * @param commonPageable
     * @return
     */
    Page<PointVo> queryPointInfo(List<DaoCriteria> criterias, CommonPageable commonPageable, String loginOrgCode);

    /**
     * 根据点ID查询点下的检查项
     *
     * @param pointId
     * @return
     */
    List<PointInputItemVo> queryPointInputItem(Long pointId);

    List<PointInputItemVo> queryPointClassInputItem(Long pointId);

    /**
     * 根据点ID查询点分类及分类下的项
     *
     * @param pointId
     * @return
     */
    Map<String, List<PointInputItemVo>> queryPointClassifyWithInputItem(Long pointId);

    /**
     * 根据点ID查询点分类及分类下的项
     *
     * @param pointId
     * @return
     */
    Map<String, PointClassifyVo> queryPointClassifyWithInputItemVo(Long pointId);

    /**
     * 根据点ID查询点图片信息
     *
     * @param pointId
     * @return
     */
    List<PointPhoto> queryPointPhoto(Long pointId);

    /**
     * 添加点的图片
     *
     * @param pointId
     */
    void addPointPhoto(Long pointId);

    /**
     * 根据点id获取点的分类
     *
     * @param pointId
     * @return
     */
    List<PointClassify> queryPointClassify(Long pointId);

    List<Map<String, Object>> queryPointClassifyByRouteIdAndPointId(Long routeId, Long pointId);

    /**
     * 根据点ID和分类id查询对应分类下的检查项
     *
     * @param pointId
     * @return
     */
    List<PointInputItemVo> queryPointInputItemByClassify(Long pointId, Long classifyId);

    /**
     * 查询用户登录公司全部巡检点
     *
     * @param ids
     * @param names
     * @param orgCode
     * @return
     */
    List<Point> queryPointList(List<String> ids, List<String> names, String orgCode);

    List<HashMap<String, Object>> findPointList(String code, String name, String orgCode);

    /**
     * 根据点编号获取点信息
     *
     * @param params
     * @return
     */
    Point queryPointByPointNo(HashMap<String, Object> params);

    /**
     * 设置巡检点巡检模式
     *
     * @param pointId
     * @param isOffine
     * @return
     */
    Point setPatrolMode(Long pointId, Boolean isOffine);

    /**
     * 手机app条件查询巡检点
     *
     * @param param
     * @param commonPageable
     * @return
     */
    Page<PointVo> queryPointByPage(HashMap<String, Object> param, CommonPageable commonPageable);

    /**
     * 移动巡检  查询巡检点详情
     *
     * @param id
     * @return
     */
    Map queryPointDetailById(Long id);

    Map queryPointDetailById1(String toke, String product, String appKey,Long id);

    Map queryPointDetailByIdInVersion2(Long id);

    JSONObject getClassifyRiskDescMap(Long id);

    JSONObject getClassifyRiskDescMap(List<PointInputItemVo> pointInputItemVo);

    /**
     * 条件查询所有数据
     *
     * @param criterias
     * @return
     */
    List<PointVo> queryPointInfoList(List<DaoCriteria> criterias);


    /**
     * 根据ids查询点信息列表
     *
     * @param pointImportQueryParam
     * @return
     */
    List<PointVo> queryPointInfoListByIds(PointImportQueryParam pointImportQueryParam);

    /**
     * 巡检点统计
     *
     * @param paramMap
     * @return
     */
    List<HashMap<String, Object>> getSumPtByRole(HashMap<String, Object> paramMap);

    /**
     * 导入导入巡检点数据
     *
     * @param list
     */
    List<Long> addImportPoint(List<PointImportParam> list, String orgCode, String userId);

    /**
     * 风险点查询
     *
     * @param params
     * @return
     */
    Page<CheckPtListBo> getCheckPtList(String toke,String product,String appKey,CheckPtListPageParam params);

    /**
     * 风险点详细信息查询
     *
     * @param pointID
     * @return
     */
    CheckPtListBo qryPointByID(int pointID);

    List<PointClassify> queryClassByIds(List<Long> ids);


    /**
     * 初始化巡检点
     */
    public void initPointStatus();

    /**
     * 添加移动巡检点
     *
     * @param param
     */
    void addMovePoint(MovePointParam param);

    /**
     * 手机统计用户点状态图标
     *
     * @param params
     * @return
     */
    HashMap<String, Object> queryPointPie(HashMap<String, Object> params);

    List<HashMap<String, Object>> queryPointHistogram(HashMap<String, Object> params);

    List<String> qryPointNoList(List<DaoCriteria> criterias, Long pointId);


    /**
     * 查询所有检查点
     *
     * @return
     */
    List<PointVo> queryAllPoint();

    /**
     * 获取公司巡检点个数
     *
     * @param loginOrgCode
     * @return
     */
    long getPointCountByOrgCode(String loginOrgCode);

    /**
     * 获取所有离线离线巡检移动巡检点信息
     *
     * @param orgCode
     * @param startTime
     * @return
     */
    List<LeavelMovePointVo> queryLeavelPoint(String toke, String product, String appKey,String orgCode, String startTime);


    public List<Map<String, Object>> getPoints();

    /**
     * 根据点ID查询点下的旧检查项
     *
     * @param pointId
     * @return
     */
    List<PointInputItemVo> queryOldPointInputItem(Long pointId);

    List<PointResponse> getPointConfigDom();

    /**
     * 巡检点信息查询
     *
     * @param criterias
     * @return
     */
    List<Point> queryPointInfoByParms(List<DaoCriteria> criterias);

    List<Map<String, Object>> queryAllPointConfig(String loginOrgCode);
    /**
     * 根据巡检点查询检查项
     *
     * @param pointId
     * @return
     */
    List<Map<String, Object>>  queryEquipPointInputItem(Long pointId);

    Page queryPointList4Route(Long riskSourceId, String pointNo, String name, int current, int size);

    List queryPointListByRouteId(Long routeId);

    List queryEquipListByPointId(Long pointId);

    List queryItemList4RoutePoint(Long pointId, Long equipId);

    LinkedHashMap<String,Object> getRegionTress ();


    void syncPointClassify(Map<String,Object> map);
}
