package com.yeejoin.amos.supervision.business.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.supervision.core.enums.QueryOperatorEnum;
import com.yeejoin.amos.supervision.core.util.StringUtil;
import org.springframework.cglib.beans.BeanMap;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.supervision.business.constants.XJConstant;
import com.yeejoin.amos.supervision.business.util.DaoCriteria;
import com.yeejoin.amos.supervision.core.common.request.CommonRequest;

//import com.yeejoin.amos.op.core.common.query.DaoCriteria;

/**
 * 基础控制器
 * 
 * @author
 *
 */
@Deprecated
public abstract class AbstractBaseController extends BaseController{

	/*@Autowired
	private RemoteSecurityServer remoteSecurityServer;
*/
//	@Autowired
//	protected HttpServletRequest request;
//
//	/**
//	 * 成功返回状态
//	 */
//	protected static final String SUCCESS = "SUCCESS";
//
//	/**
//	 * 失败返回状态
//	 */
//	protected static final String FAILED = "FAILED";
//
//	/**
//	 * 默认页大小
//	 */
//	protected static final int DEFAULT_PAGE_SIZE = 10;
//
//	  @Autowired
//	    private RedisTemplate<String, String> redisTemplate;
//	  
//	  
//	protected String getToken() {
//        String authToken = request.getHeader("token");
//        if (authToken == null) {
//            authToken = request.getHeader("X-Access-Token");
//        }
//        return authToken;
//    }
//    
//    protected String getProduct() {
//        String authToken = request.getHeader("product");
//        if (authToken == null) {
//            authToken = request.getParameter("product");
//        }
//        return authToken;
//    }
//
//    
//    protected String getAppKey() {
//        String authToken = request.getHeader("appKey");
//        if (authToken == null) {
//            authToken = request.getParameter("appKey");
//        }
//        return authToken;
//    }
//	/**
//	 * 
//	 * <pre>
//	 * 判断当前用户角色级别：true:主管/false:装备管理员
//	 * </pre>
//	 *
//	 * @return
//	 */
//	/*protected boolean isDirector() {
//		if (getUserInfo() == null) {
//			return false;
//		}
//		return getUserInfo().getRole().getRoleType() != 3;
//	}*/
//
//	/**
//	 * 获取用户角色id
//	 * 
//	 * @return
//	 */
//	/*protected String getRoleId() {
//		if (getUserInfo() == null) {
//			return "";
//		}
//		return getUserInfo().getRole().getRoleType().toString();
//	}*/
//
//	/**
//	 * 当前登录用户信息
//	 */
//	/*protected User getUserInfo() {
//		if (getToken() == null) {
//			return null;
//		}
//		return remoteSecurityServer.loginAuthentication(getToken());
//	}*/
//	
//	 protected AgencyUserModel getUserInfo() {
//	    	AgencyUserModel userModel=null;
//	    	if(getToken()!=null){
//	    	RequestContext.setToken(getToken());
//	    	RequestContext.setProduct(getProduct());
//	    	RequestContext.setAppKey(getAppKey());
//	    	
//	    	FeignClientResult feignClientResult;
//			try {
//				feignClientResult = Privilege.agencyUserClient.getme();
//		    	 userModel = (AgencyUserModel) feignClientResult.getResult();
//
//			} catch (InnerInvokException e) {
//				e.printStackTrace();
//			}
//			
//	    	}
//	        return userModel;
//
//	       // return CurrentAuthentication.getAuthenticatedUserThreadLocal();
//	    }
//	
//	 protected String getCompanyId(ReginParams reginParams) {
//	        if (reginParams == null) {
//	            return null;
//	        }
//	        if (reginParams.getCompany() != null) {
//	            return reginParams.getCompany().getSequenceNbr().toString();
//	        }
//	        return null;
//	    }
//
//	protected String getDepartmentName(ReginParams reginParams) {
//		if (reginParams == null) {
//			return null;
//		}
//		if (reginParams.getDepartment() != null) {
//			return reginParams.getDepartment().getDepartmentName();
//		}
//		return null;
//	}
//
//	protected String getUserId() {
//		String userId = null;
//		if (getUserInfo() != null) {
//			userId = getUserInfo().getUserId();
//		}
//		return userId;
//	}
//
//	/**
//	 * 获取当前用户所属公司名称
//	 * 
//	 * @return
//	 */
//	protected String getCurrentCompanyNameOfUser() {
//		if (getUserInfo() == null) {
//			return "";
//		}
//		
//		return getSelectedOrgInfo().getCompany().getCompanyName();
//	}

	/*protected LoginUserParam getLoginUserParam() {
		LoginUserParam param = CurUserCompanyCache.getInstance().getCurCompany(getUserId(), getToken());
		return param;

	}*/

	
//	   private String buildKey(String userId, String token) {
//	        //return "region_" + userId + "_" + token.substring(0, token.indexOf('_', 1));
//	        return "region_" + userId + "_" + token;
//
//	    }

//	    protected void saveSelectedOrgInfo(ReginParams reginParams) {
//	        redisTemplate.opsForValue().set(buildKey(getUserId(), getToken()), JSONObject.toJSONString(reginParams));
//	    }

//	    protected ReginParams getSelectedOrgInfo() {
//	        return JSON.parseObject(redisTemplate.opsForValue().get(buildKey(getUserId(), getToken())), ReginParams.class);
//	    }
	/**
	 * 获取请求的cookies
	 * 
	 * @return
	 */
//	protected HashMap<String, String> getCookInfoMap() {
//		HashMap<String, String> map = new HashMap<String, String>();
//		Cookie[] cookies = request.getCookies();
//		if (cookies != null) {
//			for (Cookie ck : cookies) {
//				map.put(ck.getName(), ck.getValue());
//			}
//		}
//		return map;
//	}
//	 protected String getCompanyName(ReginParams reginParams) {
//	        if (reginParams == null) {
//	            return null;
//	        }
//	        if (reginParams.getCompany() != null) {
//	            return reginParams.getCompany().getCompanyName();
//	        }
//	        return null;
//	    }
//	
//	  protected String getLoginOrgCode(ReginParams reginParams) {
//	        if (reginParams == null) {
//	            return null;
//	        }
////	        if (reginParams.getDepartment() != null) {
////	            return reginParams.getDepartment().getDeptOrgCode();
////	        }
//	        if (reginParams.getCompany() != null) {
//	            return reginParams.getCompany().getOrgCode();
//	        }
//	        return null;
//	    }
//	  
//	  
//	/**
//	 * 获取公司orgcode
//	 * 
//	 * @return
//	 *//*
//	protected String getOrgCode() {
//		if (getUserInfo() == null) {
//			return "";
//		}
//		return getUserInfo().getCompanys().getCompCode();
//	}*/
//
	/**
	 * 生成查询条件
	 * 
	 * @param queryRequests
	 *            前端查询条件
	 * @param flag
	 *            是否过滤机构标志 true过滤 false不过滤
	 * @return
	 */
	 /**
     * 生成查询条件
     */
    public List<DaoCriteria> buildDaoCriterias(List<CommonRequest> queryRequests, Boolean flag, String orgCode, String roleTypeName) {
        List<DaoCriteria> daoCriterias = new ArrayList<>();
        if (queryRequests != null && !queryRequests.isEmpty()) {
            for (CommonRequest query : queryRequests) {
                DaoCriteria criteria = new DaoCriteria();
                if (StringUtil.isNotEmpty(query.getValue())) {
                    if (query.getValue().toString().equals("-0")) {
                        criteria.setPropertyName(query.getName());
                        criteria.setOperator(QueryOperatorEnum.IS.getName());
                        criteria.setValue(null);
                    } else {
                        criteria.setPropertyName(query.getName());
                        String column = criteria.getPropertyName();
                        if (!(query.getValue() instanceof Collection<?>)
                                && column.substring(column.length() - 2, column.length()).toUpperCase().equals("ID")) {
                            criteria.setValue(Long.valueOf(query.getValue().toString()));
                        } else {
                            criteria.setValue(query.getValue());
                        }

                        String operator = query.getType();
                        if (!StringUtil.isNotEmpty(operator)) {
                            criteria.setOperator(QueryOperatorEnum.EQUAL.getName());
                        } else if (operator.equals(QueryOperatorEnum.LIKE.getName())) {
                            setLikeCriteria(criteria, query);
                        } else if (operator.equals(QueryOperatorEnum.BIGGER_EQUAL.getName())) {
                            criteria.setOperator(QueryOperatorEnum.getEnum(operator).getName());
                        } else if (operator.equals(QueryOperatorEnum.LESS_EQUAL.getName())) {
                            criteria.setOperator(QueryOperatorEnum.getEnum(operator).getName());
                        } else if (QueryOperatorEnum.getEnum(operator) != null) {
                            criteria.setOperator(QueryOperatorEnum.getEnum(operator).getName());
                        } else {
                            criteria.setOperator(operator);
                        }
                    }
                    daoCriterias.add(criteria);
                }
            }
        }
        if (flag) {
            if (XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase())
                    || XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase())) {
                daoCriterias = buildOrgDaoCriteriaInChildren(daoCriterias, orgCode);
            } else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName.toUpperCase())) {
                DaoCriteria compDaoCriteria = new DaoCriteria();
                compDaoCriteria.setPropertyName("userId");
                compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
                compDaoCriteria.setValue(getUserId());
                daoCriterias.add(compDaoCriteria);
            }

        }
        return daoCriterias;

    }
///*	public List<DaoCriteria> buildDaoCriterias(List<CommonRequest> queryRequests, Boolean flag) {
//		List<DaoCriteria> daoCriterias = new ArrayList<DaoCriteria>();
//		String orgCode = null;
//		if (queryRequests != null && !queryRequests.isEmpty()) {
//			for (CommonRequest query : queryRequests) {
//				DaoCriteria criteria = new DaoCriteria();
//				if (StringUtil.isNotEmpty(query.getValue())) {
//					if (query.getValue().toString().equals("-0")) {
//						criteria.setPropertyName(query.getName());
//						criteria.setOperator(QueryOperatorEnum.IS.getName());
//						criteria.setValue(null);
//					} else {
//						criteria.setPropertyName(query.getName());
//						String column = criteria.getPropertyName();
//						if (!(query.getValue() instanceof Collection<?>)
//								&& column.substring(column.length() - 2, column.length()).toUpperCase().equals("ID")) {
//							criteria.setValue(Long.valueOf(query.getValue().toString()));
//						} else {
//							criteria.setValue(query.getValue());
//						}
//
//						String operator = query.getType();
//						if (!StringUtil.isNotEmpty(operator)) {
//							criteria.setOperator(QueryOperatorEnum.EQUAL.getName());
//						} else if (operator.equals(QueryOperatorEnum.LIKE.getName())) {
//							setLikeCriteria(criteria, query);
//						} else if (operator.equals(QueryOperatorEnum.BIGGER_EQUAL.getName())) {
//							criteria.setOperator(QueryOperatorEnum.getEnum(operator).getName());
//						} else if (operator.equals(QueryOperatorEnum.LESS_EQUAL.getName())) {
//							criteria.setOperator(QueryOperatorEnum.getEnum(operator).getName());
//						} else if (QueryOperatorEnum.getEnum(operator) != null) {
//							criteria.setOperator(QueryOperatorEnum.getEnum(operator).getName());
//						} else {
//							criteria.setOperator(operator);
//						}
//					}
//					daoCriterias.add(criteria);
//				}
//			}
//		}
//		if (flag) {
//			ReginParams param = getSelectedOrgInfo();
//			if (param == null) {
//				throw new YeeException("非法请求");
//			}
//			String roleTypeName = param.getRole().getRoleName();
//			if (XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName)
//					|| XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName)) {
//				orgCode = param.getCompany().getOrgCode();
//				daoCriterias = buildOrgDaoCriteriaInChildren(daoCriterias, orgCode);
//			} else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName)) {
//				orgCode = param.getUserOrgCode();
//				daoCriterias = buildOrgDaoCriteriaOutChildren(daoCriterias, orgCode);
//			} else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName)) {
//				DaoCriteria compDaoCriteria = new DaoCriteria();
//				compDaoCriteria.setPropertyName("userId");
//				compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
//				compDaoCriteria.setValue(param.);
//				daoCriterias.add(compDaoCriteria);
//			}
//
//		}
//		return daoCriterias;
//
//	}*/
//    protected String getRoleTypeName(ReginParams reginParams) {
//        if (reginParams == null) {
//            return null;
//        }
//        if (reginParams.getRole() != null) {
//            return reginParams.getRole().getRoleType();
//        }
//        return null;
//    }
//    protected String getDepartmentId(ReginParams reginParams) {
//        if (reginParams == null) {
//            return null;
//        }
//        if (reginParams.getDepartment() != null) {
//            return reginParams.getDepartment().getSequenceNbr().toString();
//        }
//        return null;
//    }
//
	/**
	 * 构建数据权限 返回字段：orgCode(机构)，expression（表达式）
	 * 
	 * @return
	 */
    public HashMap<String, Object> buildMybatisDaoCriterias(String orgCode, String roleTypeName) {
        HashMap<String, Object> paramMap = new HashMap<>();
        if (XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase()) || XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase())) {
            paramMap.put("orgCode", orgCode + "%");
            paramMap.put("roleFlag", XJConstant.ADMIN_FLAG);
        } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
            paramMap.put("orgCode", orgCode + "%");
            paramMap.put("roleFlag", XJConstant.DEPART_FLAG);
        } else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName.toUpperCase())) {
            paramMap.put("userId", getUserId());
            paramMap.put("roleFlag", XJConstant.PERSON_FLAG);
        }
        return paramMap;
    }
//	/*public HashMap<String, Object> buildMybatisDaoCriterias() {
//		String orgCode = null;
//		LoginUserParam param = getLoginUserParam();
//		if (param == null) {
//			throw new YeeException("非法请求");
//		}
//		HashMap<String, Object> paramMap = new HashMap<String, Object>();
//		String roleTypeName = param.getRoleTypeName();
//
//		if (XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName) || XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName)) {
//			orgCode = param.getLoginOrgCode();
//			paramMap.put("orgCode", orgCode + "%");
//			paramMap.put("roleFlag", XJConstant.ADMIN_FLAG);
//		} else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName)) {
//			orgCode = param.getUserOrgCode();
//			paramMap.put("orgCode", orgCode + "%");
//			paramMap.put("roleFlag", XJConstant.DEPART_FLAG);
//		} else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName)) {
//			paramMap.put("userId", param.getUserId());
//			paramMap.put("roleFlag", XJConstant.PERSON_FLAG);
//		}
//		return paramMap;
//
//	}*/
    public HashMap<String, Object> buildMybatisCriterias(String orgCode, String roleTypeName) {
        HashMap<String, Object> paramMap = new HashMap<>();
        if(StringUtil.isNotEmpty(roleTypeName)){
        	 if (XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase()) || XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase())) {
                 paramMap.put("orgCode", orgCode);
                 paramMap.put("roleFlag", XJConstant.ADMIN_FLAG);
             } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
                 paramMap.put("orgCode", orgCode);
                 paramMap.put("roleFlag", XJConstant.DEPART_FLAG);
             } else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName.toUpperCase())) {
                 paramMap.put("userId", getUserId());
     			 paramMap.put("orgCode", orgCode);
                 paramMap.put("roleFlag", XJConstant.PERSON_FLAG);
             }
        }else{
        	paramMap.put("orgCode", orgCode);
        }
        return paramMap;

    }
//	
//	/*public HashMap<String, Object> buildMybatisCriterias() {
//		String orgCode = null;
//		LoginUserParam param = getLoginUserParam();
//		if (param == null) {
//			throw new YeeException("非法请求");
//		}
//		HashMap<String, Object> paramMap = new HashMap<String, Object>();
//		String roleTypeName = param.getRoleTypeName();
//
//		if (XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName) || XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName)) {
//			orgCode = param.getLoginOrgCode();
//			paramMap.put("orgCode", orgCode);
//			paramMap.put("roleFlag", XJConstant.ADMIN_FLAG);
//		} else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName)) {
//			orgCode = param.getUserOrgCode();
//			paramMap.put("orgCode", orgCode);
//			paramMap.put("roleFlag", XJConstant.DEPART_FLAG);
//		} else if (XJConstant.ROLE_NAME_PERSON.equals(roleTypeName)) {
//			paramMap.put("userId", param.getUserId());
//			paramMap.put("roleFlag", XJConstant.PERSON_FLAG);
//		}
//		return paramMap;
//
//	}*/
//
//	/**
//	 * 暂时未用到
//	 * 
//	 * @return
//	 */
///*	public List<DaoCriteria> buildDaoCriteriasNoParam() {
//		List<DaoCriteria> daoCriterias = new ArrayList<DaoCriteria>();
//		String orgCode = getOrgCode();
//		if (isDirector()) {
//			daoCriterias = buildOrgDaoCriteriaInChildren(daoCriterias, orgCode);
//		} else {
//			daoCriterias = buildOrgDaoCriteriaOutChildren(daoCriterias, orgCode);
//		}
//		return daoCriterias;
//	}*/
    
	/**
	 * 
	 * <pre>
	 * 生成通过当前用户所属组织机构（包含子机构）过滤的查询条件
	 * </pre>
	 *
	 * @param daoCriterias
	 *            查询条件集合
	 * @return
	 */
	public List<DaoCriteria> buildOrgDaoCriteriaInChildren(List<DaoCriteria> daoCriterias, String orgCode) {

		// 添加所属公司的过滤条件
		DaoCriteria compDaoCriteria = new DaoCriteria();
		compDaoCriteria.setPropertyName("orgCode");
		compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
		compDaoCriteria.setValue(orgCode);
		daoCriterias.add(compDaoCriteria);

		// 添加子公司下的过滤条件
		DaoCriteria childCompDaoCriteria = new DaoCriteria();
		childCompDaoCriteria.setPropertyName("orgCode");
		childCompDaoCriteria.setOperator(QueryOperatorEnum.LIKE.getName());
		childCompDaoCriteria.setValue(orgCode + "*%");
		daoCriterias.add(childCompDaoCriteria);
		return daoCriterias;
	}

//	/**
//	 * 
//	 * <pre>
//	 * 生成通过当前用户所属组织机构（不包含子机构）过滤的查询条件
//	 * </pre>
//	 *
//	 * @param daoCriterias
//	 *            查询条件集合
//	 * @param orgCode
//	 * @return
//	 */
//	public List<DaoCriteria> buildOrgDaoCriteriaOutChildren(List<DaoCriteria> daoCriterias, String orgCode) {
//		/**
//		 * 当前用户所属公司
//		 */
//
//		DaoCriteria compDaoCriteria = new DaoCriteria();
//		compDaoCriteria.setPropertyName("orgCode");
//		compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
//		compDaoCriteria.setValue(orgCode);
//		daoCriterias.add(compDaoCriteria);
//		return daoCriterias;
//	}

	/**
	 * 对like查询语句的内容进行特殊字符转义
	 * 
	 * @param criteria
	 * @param query
	 */
	@SuppressWarnings("unchecked")
	public void setLikeCriteria(DaoCriteria criteria, CommonRequest query) {
		if (query.getValue() instanceof List) {
			List<String> value = (List<String>) query.getValue();
			if (!value.isEmpty()) {
				value = value.stream().map(s -> {
					String str = s.replace("%", "/%").replace("_", "/_");
					return "%" + str + "%";
				}).collect(Collectors.toList());
				criteria.setValue(value);
				criteria.setOperator(QueryOperatorEnum.LIKE.getName());
			}
		} else {
			String value = (String) query.getValue();
			if (value != null) {
				value = value.replace("%", "/%").replace("_", "/_");
				criteria.setValue("%" + value + "%");
				criteria.setOperator(QueryOperatorEnum.LIKE.getName());
			}
		}
	}

//	/**
//	 * <pre>
//	 * 提取错误异常中的错误消息
//	 * </pre>
//	 * 
//	 * <p>
//	 * 当实体类中对属相注解了以下类似的注解，需要用try.catch语句捕获异常，使用 #getErrorMessage(Exception)
//	 * 提取出异常信息NotNull(message = "属性不能为空！")
//	 * </p>
//	 * 
//	 * @see {@code NotBlank} ... NotNull、NotEmpty...
//	 * @see {@code Valid}
//	 * 
//	 * @param e
//	 * @return
//	 */
//	public String getErrorMessage(Exception e) {
//		StringBuilder message = new StringBuilder();
//		if (e instanceof TransactionSystemException) {
//			TransactionSystemException exception = (TransactionSystemException) e;
//			if (exception.getRootCause() instanceof ConstraintViolationException) {
//				ConstraintViolationException root = (ConstraintViolationException) exception.getRootCause();
//				root.getConstraintViolations().forEach(constraintViolation -> {
//					message.append(constraintViolation.getMessageTemplate());
//				});
//			} else {
//				message.append(e.getMessage());
//			}
//		} else if (e instanceof ConstraintViolationException) {
//			((ConstraintViolationException) e).getConstraintViolations()
//					.forEach(constraintViolation -> message.append(constraintViolation.getMessageTemplate()));
//		} else {
//			message.append("操作异常！");
//		}
//		return message.toString();
//	}
//	
    public static <T> List<Map<String, Object>> objectsToMaps(List<T> objList) {
  	  List<Map<String, Object>> list = Lists.newArrayList();
  	  if (objList != null && objList.size() > 0) {
  	    Map<String, Object> map = null;
  	    T bean = null;
  	    for (int i = 0,size = objList.size(); i < size; i++) {
  	      bean = objList.get(i);
  	      map = beanToMap(bean);
  	      list.add(map);
  	    }
  	  }
  	  return list;
  }
    
    public static <T> Map<String, Object> beanToMap(T bean) {
  	  Map<String, Object> map = Maps.newHashMap();
  	  if (bean != null) {
  	    BeanMap beanMap = BeanMap.create(bean);
  	    for (Object key : beanMap.keySet()) {
  	    if("sequenceNbr".equals(key+"")){
    	      map.put(key+"", beanMap.get(key)+"");

  	    }else{
    	      map.put(key+"", beanMap.get(key));

  	    }
  	    }
  	  }
  	  return map;
  	}

  	public ReginParams.PersonIdentity opIdentifyInfo(){
		return getSelectedOrgInfo().getPersonIdentity();
	}
}
