package com.yeejoin.amos.supervision.business.dao.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.annotations.DataAuth;
import com.yeejoin.amos.supervision.business.dto.CheckReportMapperDto;
import com.yeejoin.amos.supervision.core.common.dto.CheckReportCompanyDto;
import com.yeejoin.amos.supervision.core.common.dto.CheckReportDto;
import com.yeejoin.amos.supervision.core.common.dto.CheckReportParamDto;
import com.yeejoin.amos.supervision.dao.entity.CheckReport;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface CheckReportMapper extends BaseMapper<CheckReport> {

    /**
     * 根据计划任务ID获取相关数据
     * @param id
     */
    CheckReportMapperDto queryByPlanTaskId(long id);

    @DataAuth(interfacePath = "supervision/check/report/page")
    IPage<CheckReportDto> selectPageList(Page page, @Param("queryParam") CheckReportParamDto queryParam);

    CheckReportDto selectDetailById(@Param("checkReportId") Long id);

    List<CheckReportCompanyDto> getCheckReportCompanyList(Long planTaskId);
}
