package com.yeejoin.amos.supervision.business.dao.mapper;

import com.yeejoin.amos.supervision.business.entity.mybatis.extend.LatentDangerBo;
import com.yeejoin.amos.supervision.business.entity.mybatis.extend.LatentDangerNoticeBo;
import com.yeejoin.amos.supervision.business.param.LatentDangerListParam;
import com.yeejoin.amos.supervision.business.param.PageParam;
import com.yeejoin.amos.supervision.core.common.response.DangerListResponse;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LatentDangerMapper extends BaseMapper {

    Integer save(LatentDangerBo latentDangerBo);

    List<LatentDangerBo> listByMap(Map<String, Object> map);

    Long countByMap(Map<String, Object> map);

    LatentDangerBo getById(Long id);

    Integer update(LatentDangerBo latentDangerBo);

    LatentDangerBo getByInstanceId(String instanceId);

    List<LatentDangerBo> listOfOvertime();

    Integer countNotFinishByFlowId(String flowId);

    List<LatentDangerBo> listNotFinishByPointId(HashMap<String, Object> params);

    Long countByFlowUserIds(String userId);

    Long countNotFinishByTypeAndDeptId(@Param("type") Integer type, @Param("departmentId") String departmentId);

    String getNotFinishIdsByTypeAndDeptId(@Param("type") Integer type, @Param("departmentId") String departmentId);

    void deleteByIds(List<Long> dangerIds);

    /**
     * 查询治理期限即将到期的隐患
     *
     * @return
     */
    List<LatentDangerNoticeBo> listNeedNoticeDanger();

    /**
     * 根据隐患id获取评审信息
     *
     * @param dangerId
     * @return
     */
    List<HashMap<String, Object>> getReViewInfo(Long dangerId);

    List<DangerListResponse> dangerListByMap(PageParam pageParam);

    Long countDangerListByMap(PageParam pageParam);

    List<LatentDangerBo> getByBathBusinessKeys(@Param("businessKeys") List<String> businessKeys, @Param("latentDangerListParam") LatentDangerListParam latentDangerListParam);

    int countByBathBusinessKeys(@Param("businessKeys") List<String> businessKeys, @Param("latentDangerListParam") LatentDangerListParam latentDangerListParam);

    int countByStatus(@Param("businessKeys") List<String> businessKeys);

    void updateCheckInputDangerState(@Param("id") Long id, @Param("code") int code);

    LatentDangerBo getbyBusinessKey(@Param("businessKey") String businessKey);

    Map<String, Object> getLatentDangerByLatentDangerId(@Param("latentDangerId") Long latentDangerId);
}
