package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.RoutePointItem;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface IRoutePointItemDao extends BaseDao<RoutePointItem, Long> {

    @Modifying
    @Transactional
    @Query(value = "delete from p_route_point_item WHERE route_point_id = ?1", nativeQuery = true)
    void delRoutePointItem(Long routePointId);

    @Modifying
    @Transactional
    @Query(value = "DELETE FROM p_route_point_item WHERE point_input_item_id IN (?1)", nativeQuery = true)
    void delRoutePointItemByItemId(List<Long> pItemIds);

    @Modifying
    @Transactional
    @Query(value = "delete from p_route_point_item WHERE id in (?1)", nativeQuery = true)
    int deleteByRoutePointItemId(List<Long> delRoutePointItemIds);

    @Modifying
    @Transactional
    @Query(value = "delete from p_route_point_item WHERE input_item_id in (?1) and plan_id = (?2)", nativeQuery = true)
    int deleteByRoutePointItemIdAndPlanId(List<String> itemIds, Long planId);

    @Modifying
    @Transactional
    @Query(value = "delete from p_route_point_item WHERE plan_id = ?1", nativeQuery = true)
    void deleteByPlanId(Long planId);
}
