package com.yeejoin.amos.supervision.business.service.impl;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.google.common.collect.Lists;
import com.yeejoin.amos.supervision.business.dao.mapper.InputItemMapper;
import com.yeejoin.amos.supervision.business.dao.mapper.RoutePointItemMapper;
import com.yeejoin.amos.supervision.business.dao.repository.IPlanDao;
import com.yeejoin.amos.supervision.business.dao.repository.IRoutePointDao;
import com.yeejoin.amos.supervision.business.dao.repository.IRoutePointItemDao;
import com.yeejoin.amos.supervision.business.param.InputItemPageParam;
import com.yeejoin.amos.supervision.business.service.intfc.IRoutePointItemService;
import com.yeejoin.amos.supervision.business.vo.RoutePointItemVo;
import com.yeejoin.amos.supervision.common.enums.PlanStatusEnum;
import com.yeejoin.amos.supervision.dao.entity.InputItem;
import com.yeejoin.amos.supervision.dao.entity.Plan;
import com.yeejoin.amos.supervision.dao.entity.RoutePoint;
import com.yeejoin.amos.supervision.dao.entity.RoutePointItem;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("routePointItemService")
public class RoutePointItemServiceImpl implements IRoutePointItemService {

    @Autowired
    private IRoutePointItemDao routePointItemDao;

    @Autowired
    private IRoutePointDao routePointDao;

    @Autowired
    private IPlanDao planDao;

    @Autowired
    private InputItemMapper inputItemMapper;

    @Autowired
    private RoutePointItemMapper routePointItemMapper;

    @Override
    @Transactional
    public List<RoutePointItem> addRoutePointItemList(Plan plan, List<Long> inputItemIds, Boolean status, String userId) {
        Long planId = plan.getId();
        Long routeId = plan.getRouteId();
        if (routeId != null && planId != null) {
            if (status) {
                planDao.updatePlanStatus(PlanStatusEnum.EXAMINE_DEVELOPED.getValue(), planId);
            } else {
                if (CollectionUtils.isNotEmpty(inputItemIds)) {
                    List<InputItem> inputItemList = inputItemMapper.findByIdIn(inputItemIds);
                    List<RoutePoint> routePointList = routePointDao.findByRouteId(routeId);
                    if (CollectionUtils.isNotEmpty(inputItemList) && CollectionUtils.isNotEmpty(routePointList)) {
                        List<RoutePointItem> list = new ArrayList<>();
                        routePointList.stream().forEach(route -> {
                            Long routePointId = route.getId();
                            inputItemList.stream().forEach(item -> {
                                RoutePointItem routePointItem = new RoutePointItem();
                                routePointItem.setPlanId(planId);
                                routePointItem.setInputItemId(item.getId());
                                routePointItem.setBasisJson(item.getBasisJson());
                                routePointItem.setOrderNo(item.getOrderNo());
                                routePointItem.setRoutePointId(routePointId);
                                routePointItem.setCreatorId(userId);
                                routePointItem.setCreateDate(new Date());
                                list.add(routePointItem);
                            });
                        });
                        return routePointItemDao.saveAll(list);
                    }
                }
            }
        }
        return Lists.newArrayList();
    }

    @Override
    public Page<RoutePointItemVo> queryPage(InputItemPageParam param) {
        long total = routePointItemMapper.queryPageCount(param);
        List<RoutePointItemVo> content = routePointItemMapper.queryPage(param);
        Page<RoutePointItemVo> result = new PageImpl<RoutePointItemVo>(content, param, total);
        return result;
    }

    @Override
    public Integer deleteByIdIn(List<String> itemIds, Long planId) {
        if (CollectionUtils.isNotEmpty(itemIds) && ObjectUtils.isNotEmpty(planId)) {
            return routePointItemDao.deleteByRoutePointItemIdAndPlanId(itemIds, planId);
        }
        return 0;
    }
}
