/*package com.yeejoin.amos.maintenance.business.service.impl;

import java.util.ArrayList;
import java.util.HashMap;

import java.util.List;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.maintenance.business.constants.XJConstant;
import com.yeejoin.amos.maintenance.business.dao.mapper.UserMapper;
import com.yeejoin.amos.maintenance.business.dao.repository.AppVersionDao;
import com.yeejoin.amos.maintenance.business.dao.repository.ICompanyDao;
import com.yeejoin.amos.maintenance.business.dao.repository.IMsgSubscribeDao;
import com.yeejoin.amos.maintenance.business.dao.repository.IRouteDao;
import com.yeejoin.amos.maintenance.business.dao.repository.IUserDao;
import com.yeejoin.amos.maintenance.business.param.LoginUserParam;
import com.yeejoin.amos.maintenance.business.param.UserMsgInitParam;
import com.yeejoin.amos.maintenance.business.service.intfc.IMsgSubscribeService;
import com.yeejoin.amos.maintenance.business.service.intfc.IUserService;
import com.yeejoin.amos.maintenance.business.vo.UserCompanyVo;
import com.yeejoin.amos.maintenance.common.enums.MsgSubscribeTypeEnum;
import com.yeejoin.amos.maintenance.dao.entity.AppVersion;
import com.yeejoin.amos.maintenance.dao.entity.MsgSubscribe;
import com.yeejoin.amos.maintenance.dao.entity.Route;
import com.yeejoin.amos.maintenance.dao.entity.SCompany;
import com.yeejoin.amos.maintenance.dao.entity.SUser;
import com.yeejoin.amos.security.entity.User;
import com.yeejoin.amos.security.entity.dto.UserDTO;

@Service("userService")
public class UserServiceImpl implements IUserService {

	@Autowired
	private IRouteDao iRouteDao;
	
	@Autowired
	private IMsgSubscribeDao msgSubscribeDao;
	
	@Autowired
	private UserMapper userMapper;
	
	@Autowired
	private AppVersionDao appVersionDao;
	
	@Autowired
	private IUserDao iUserDao;
	
	@Autowired
	private ICompanyDao iCompanyDao;
	
	@Autowired
	private IMsgSubscribeService msgSubscribeService;
	
	@Override
	public List<AgencyUserModel> findAll() {
		return iUserDao.findAll();
	}

	@Override
	public void save(UserDTO userDTO) {
		//初始化用户消息订阅
		UserMsgInitParam userInitParam = new UserMsgInitParam();
		userInitParam.setOrgCode(userDTO.getOrgCode());
		userInitParam.setUserId(userDTO.getId());
		userInitParam.setRoleTypeName(userDTO.getRole().getRoleTypeName());
		userInitParam.setInit(true);
		saveUserMsgInit(userInitParam);
	}
	
	*//**
	 * 新增用户时初始化消息订阅(p_msg_subscribe)表
	 * 
	 * @param userDTO
	 *//*
	public List<MsgSubscribe> saveUserMsgInit(UserMsgInitParam userInitParam) {
		Long count = msgSubscribeDao.countByUserId(userInitParam.getUserId());
		if (count > 0) {	//	已存在用户订阅，直接返回
			return msgSubscribeService.queryMsgSubscribes(userInitParam.getUserId());
		}
		List<MsgSubscribe> msgConfigs = new ArrayList<MsgSubscribe>();
		for (MsgSubscribeTypeEnum type : MsgSubscribeTypeEnum.values()) {
			MsgSubscribe msgSub = new MsgSubscribe();
			msgSub.setOrgCode(userInitParam.getOrgCode());
			msgSub.setUserId(userInitParam.getUserId());
			if (type.equals(MsgSubscribeTypeEnum.PLANBEGIN)
					|| type.equals(MsgSubscribeTypeEnum.PLANWARN)
					|| type.equals(MsgSubscribeTypeEnum.PLANEND)) {
				msgSub.setAttribute1("False");
				msgSub.setAttribute2(10 + "");
			} else if (type.equals(MsgSubscribeTypeEnum.CHECKTYPE)
					|| type.equals(MsgSubscribeTypeEnum.CHECKEMAIL)) {
				msgSub.setAttribute1("error");
			} 
			*//**else if (type.equals(MsgSubscribeTypeEnum.ROUTE) && !userInitParam.getInit()) {
				// TODO 查询该用户下的路线
				String roleTypeName = userInitParam.getRoleTypeName();
				String orgCode = userInitParam.getOrgCode();
				
				Specification<Route> spec = new Specification<Route>() {// 构建查询条件

					@Override
					public Predicate toPredicate(Root<Route> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
						List<Predicate> predicate = new ArrayList<>();
						if (!ObjectUtils.isEmpty(roleTypeName)) {
							if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName) 
									|| XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName)) {
								predicate.add(cb.like(root.get("orgCode").as(String.class), orgCode + "%"));
							} else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName)) {
								String orgCode_ = orgCode;
								if (orgCode.indexOf("-") != -1) {
									orgCode_ = orgCode.substring(0, orgCode.indexOf("-"));
								}
								predicate.add(cb.like(root.get("orgCode").as(String.class), orgCode_ + "%"));
							} else {
								predicate.add(cb.equal(root.get("orgCode").as(String.class), orgCode));
							}
						}
						Predicate[] pre = new Predicate[predicate.size()];
						return query.where(predicate.toArray(pre)).getRestriction();
					}

				};
				List<Route> routeList = iRouteDao.findAll(spec);
				List<Long> routeIdList = new ArrayList<>();
				for (Route route : routeList) {
					routeIdList.add(route.getId());
				}
				String routeIds = StringUtils.join(routeIdList.toArray(), ",");
				msgSub.setAttribute1(routeIds);
			}*//*
			msgSub.setMsgType(type.getName());
			msgSubscribeDao.saveAndFlush(msgSub);
			msgConfigs.add(msgSub);
			
		}
		return msgConfigs;
	}

	@Override
	public void delete(List<User> user) {
		beforeDeleteUser(user);
	}
	
	*//**
	 * 删除用户时更新消息订阅(p_msg_subscribe)表
	 * 
	 * @param user
	 *//*
	private void beforeDeleteUser(List<User> user) {
		List<Long> userIds = new ArrayList<>();
		for (User _user : user) {
			userIds.add(_user.getId());
		}
		msgSubscribeDao.delMsgSubscribeByUserId(userIds);
	}

	@Override
	public List<SUser> queryUserByOrgCode(String orgCode) {
		return userMapper.queryUserByOrgCode(orgCode);
	}

	@Override
	public String queryUserCompanyNameByUserId(String orgCode) {
		return userMapper.queryUserCompanyNameByUserId(orgCode);
	}
	
	public AppVersion queryAppLastVersion() {
		return appVersionDao.findLastVersion();
	}

	@Override
	public UserCompanyVo qryLoginUserAndCompany(LoginUserParam param) {
		Long userId = param.getUserId();
		SUser user = iUserDao.findOne(userId);
		String[] orgs = param.getLoginOrgCode().split("\\*");
		String companyId = orgs[orgs.length - 1];
		SCompany company = iCompanyDao.findOne(companyId);
		UserCompanyVo userCompanyVo = new UserCompanyVo();
		userCompanyVo.setCompany(company);
		userCompanyVo.setUser(user);
		return userCompanyVo;
	}

	@Override
	public void initUserMsgSubscribe() {
		List<SUser> userList = iUserDao.findAll();
		for (SUser user : userList) {
			UserMsgInitParam userInitParam = new UserMsgInitParam();
			userInitParam.setInit(true);
			userInitParam.setOrgCode(user.getOrgCode());
			userInitParam.setUserId(user.getId());
			saveUserMsgInit(userInitParam);
		}
	}

	@Override
	public boolean existUser(String userId) {
		SUser user = iUserDao.findOne(Long.parseLong(userId));
		if (!ObjectUtils.isEmpty(user)) {
			return true;
		}
		return false;
	}
}
*/