package com.yeejoin.amos.boot.module.common.api.feign;

import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrFormDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

// 消防监督调用
@FeignClient(name = "${supervision.feign.name}", path = "supervision", configuration = {MultipartSupportConfig.class})
public interface SupervisionFeign {

    @RequestMapping(value = "/api/point/teamInput", method = RequestMethod.POST, consumes = "application/json")
    ResponseModel asyncOwner(@RequestBody OrgUsrFormDto orgUsrFormDto);

    @RequestMapping(value = "/api/point/delete", method = RequestMethod.POST, consumes = "application/json")
    ResponseModel deleteOwner(@RequestBody Long id);
}

