package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.Point;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

@Repository("iPointDao")
public interface IPointDao extends BaseDao<Point, Long> {

    @Modifying
    @Transactional
    @Query(value = "UPDATE p_point SET is_delete = 1 WHERE id IN (?1)", nativeQuery = true)
    void delPointById(List<Long> ids);

    @Query(value = "SELECT COUNT(1) FROM p_point p WHERE is_delete = 0 AND p.point_no = (?1) AND p.org_code = (?2)", nativeQuery = true)
    int findByPointNo(String pointNo, String orgCode);

    Point findByOriginalId(String originalId);

    @Query(value = "select * from p_point where original_id in ?1 and is_delete =0", nativeQuery = true)
    List<Point> listByOriginalIds(List<String> originalIds);
    
    Optional<Point> findById(Long id);

    @Query(value = "SELECT id FROM p_point p WHERE p.point_no = (?1) AND p.original_id = (?2)", nativeQuery = true)
    Long findPointByEquipmentIdAndFireFacilityId(String equipmentId, String specificId);

    @Modifying
    @Transactional
    @Query(value = "DELETE FROM p_point WHERE id = (?1)", nativeQuery = true)
    void delPointBIds(Long id);

    List<Point> findAllByOriginalId(String relationId);

    @Modifying
    @Transactional
    @Query(value = "UPDATE p_point SET is_delete = 1 WHERE point_no IN (?1)", nativeQuery = true)
    void delPointByPointNo(Long id);

    @Query(value = "SELECT id FROM p_point p WHERE is_delete = 0 AND p.point_no = (?1)", nativeQuery = true)
    List<Long> findPointByPointNo(String pointNo);
}
