package com.yeejoin.amos.boot.module.jg.biz.discardOrder.strategy;

import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationEq;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import com.yeejoin.amos.boot.module.jg.biz.discardOrder.factory.support.SupportableDiscardOrderCheck;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
public class InstallNoticeDiscardOrderCheck implements SupportableDiscardOrderCheck {

    private final JgUseRegistrationMapper useRegistrationMapper;

    @Override
    public boolean support(String clazz) {
        return JgInstallationNoticeServiceImpl.class.getSimpleName().equals(clazz);
    }

    @Override
    public Boolean check(List<String> records) {
        List<JgUseRegistrationEq> useRegistrationEqs = useRegistrationMapper.selectListForInstallNoticeDiscard(records);
        if (!useRegistrationEqs.isEmpty()) {
            String msg = String.format("存在设备正在办理或已办理业务：%s，不能进行作废！", String.join(",", useRegistrationEqs.stream().map(u -> GenericDiscardOrderCheck.buildErrorMsg(u.getRecUserName())).collect(Collectors.toSet())));
            throw new RuntimeException(msg);
        }
        return true;
    }
}
