package com.yeejoin.amos.boot.module.cylinder.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.cylinder.api.dto.InspectionDetectionInfoModel;
import com.yeejoin.amos.boot.module.cylinder.biz.service.impl.InspectionDetectionInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;


/**
 * 安全追溯-检验检测信息表
 *
 * @author cpp
 * @date 2023-04-06 19:18:21
 */
@RestController
@Api(tags ="安全追溯-检验检测信息表Api")
@RequestMapping(value = "/api/inspectiondetectioninfo")
public class InspectionDetectionInfoController extends BaseController {
    @Autowired
    private InspectionDetectionInfoServiceImpl infoService;

    /**
     * 检验检测信息（查询）
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectInspect")
    @ApiOperation(httpMethod = "GET", value = "检验检测信息（查询）", notes = "检验检测信息（查询）")
    public ResponseModel<InspectionDetectionInfoModel> selectInspect(String superviseCode) {
        return ResponseHelper.buildResponse(infoService.selectInspect(superviseCode));
    }



}
