package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum EnterpriseEnums {

    /**
     * 企业注册类型
     */
    // 企业单位
    QY_DW("QY_DW","6597", "企业单位"),
    // 事业单位
    SY_DW("SY_DW", "6598","事业单位"),
    // 个人主体
    GR_ZT("GR_ZT", "6599","个人主体");

    String type;
    String code;
    String typeName;



    public static EnterpriseEnums getEnumByType(String type) {
        for (EnterpriseEnums value : EnterpriseEnums.values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
